function vrednost_u_tacki=PrviNjutn(tacka, cvorovi, vrednosti_funkcije)
% Funkcija "PrviNjutn" formira odgovarajuci polinom na osnovu cvorova i
% vrednosti funkcije u njima, te konkretne tacke u kojoj traimo priblinu
% vrednost.
%
% Funkcija PrviNjutn ce za slucaj da je unet drugaciji broj argumenata od
% 3, izdati upozorenje o tome na izlaz o greci.
%
% Funkcija ce obustaviti kreiranje polinoma za slucaj da se "tacka" poklapa
% sa nekim od cvorova. Tada se jednostavno vraca vrednost iz tabele.
%
% Kako prvi Njutnov polinom koristimo kada se "tacka" nalazi izmedju pocetna
% dva cvora interpolacije (x1 i x2), funkcija polinome formira na restrikciji
% intervala ako nije x1<tacka<x2.

if (nargin~=3)
    error('Broj unetih argumenata funkcije PrviNjutn nije korektan!');
end

pom=find(cvorovi==tacka); % indeksi svih cvorova koji su jednaki "tacka"
if pom>0 % ako takav cvor postoji
    vrednost_u_tacki=vrednosti_funkcije(pom); % pom je sigurno skalar, jer vai ekvidistantna podela
    clear pom;
    return;
else
    pom=find(cvorovi<tacka); % daje indekse onih cvorova koji su manji od "tacka"
    indeks=pom(length(pom)); % uzima vrednost poslednjeg cvora manjeg od "tacka"
    clear pom;
    % sada cemo da kreiramo tablice konacnih razlika pocev od "indeks" cvora
    tablica=zeros(length(vrednosti_funkcije)-indeks+1); % "+1" jer nam treba i jedan manji
    for i=1:length(tablica)
        tablica(i,1)=vrednosti_funkcije(i+indeks-1); % u prvu kolonu smetamo vrednosti funkcije u cvorovima pocev od indeks cvora
    end
    red=1; % red konacne razlike
    for j=2:length(tablica)
        for i=1:length(tablica)-red
            tablica(i,j)=tablica(i+1,j-1)-tablica(i,j-1);
        end
        red=red+1;
    end
    
    clear red, clear i, clear j; % oslobadjamo se brojaca i reda iz memorije

    korak=cvorovi(2)-cvorovi(1); % poto nam za formiranje q treba korak koricen za tabeliranje    
    q=(tacka-cvorovi(indeks))./korak; % x0=cvorovi(indeks): najveci manji cvor
    clear korak, clear indeks; % oslobadjanje indeksa i koraka

% Prvi Njutnov polinom za n+1 cvorova    
% L(x0+qh)=f+f1*q/1!+f2*q(q-1)/2!+...+fn*q(q-1)...(q-n+1)/n!
% gde je f=f(x0), a fi konacna razlika i-tog reda
    
    suma=0;
    qpom=1; % q(q-1)(q-2)...(q-k+1)
    fakt=1; % 1!,...,k!
    
    for i=1:length(tablica);
        suma=suma+qpom*tablica(1,i)/fakt;
        qpom=qpom*(q-i+1);
        fakt=fakt*i;
    end

% Pokaimo ta radi prethodna petlja za 5 cvorova. Imamo, znaci, f(x0) i
% cetiri konacne razlike. Prvi Njutnov polinom je predstavljen u prethodnom
% komentaru i u ovom slucaju iznosi:
% f + f1*q/1! + f2*q(q-1)/2! + f3*q(q-1)(q-2)/3! + f4*q(q-1)(q-2)(q-3)/4!
% Naa petlja daje:
% 1) suma=f qpom=q fakt=1! ..... +
% 2) suma+=q*f1 qpom=q(q-1) fakt=2! ..... +
% 3) suma+=f2*q(q-1)/2! qpom=q(q-1)(q-2) fakt=3! ..... +
% 4) suma+=f3*q(q-1)(q-2)/3! qpom=q(q-1)(q-2)(q-3) fakt=4! ..... +
% 5) suma+=f4*q(q-1)(q-2)(q-3)/4! qpom=q(q-1)(q-2)(q-3)(q-4) fakt=5! ..... +
% to je i trebalo da se dobije
    
    vrednost_u_tacki=suma; % vrednost koju funkcija vraca
    clear q, clear suma, clear qpom, clear fakt; % oslobadjanje memorije
    return;
end