% funkcija koja izracunava vrednost integrala koristeci Simpsonovu
% formulu
%
% Ulazne velicine:
% a,b - granice odredjenog integrala
% k - broj intervala koje se koriste u Simpsonovoj formuli, uvek paran broj
%
% Izlazne velicine:
% S - vrednost odredjenog integrala 

function S=SimpsonFormula(a,b,k)
%duzina intervala izmedju tacaka
h=(b-a)/k;      
%formiranje niza vrednosti funkcije u zadatim tackama
X=a:h:b;        
Y=funkcija(X);
%izdvajanje vrednosti funkcije koje se nalaze na parnim, 
%odnosno neparnim mestima u nizu
%parni i neparni indeksi imaju zamenjena mesta u programu, 
%jer u Simpsonovoj formuli pocetni indeks niza je 0, 
%dok u Matlab-u nizovi se indeksiraju od 1.
parni=Y(3:2:k);
neparni=Y(2:2:k);
%Simpsonova formula
S=(h/3)*( Y(1)+2*sum(parni)+4*sum(neparni)+Y(k+1) );
