function zadatak13(A)
%----------------------------------------------------------------------------------------------------------------------------%
% clc-Clear command window                                                                                                   %  
% clf-Clear current figure                                                                                                   %
%----------------------------------------------------------------------------------------------------------------------------%
clc

disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')

%----------------------------------------------------------------------------------------------------------------------------%
% Unos potrebnih promenjljivih:                                                                                              %
%----------------------------------------------------------------------------------------------------------------------------%
epsilon=input('Unesi tacnost: ');
disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')
kk=[];
kkk=[];
sopstvena_vrednost=[];

x=sym('x');
fprintf('Za slucajno generisanu matricu formata 3x3: ')
A
disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')
format long;

%----------------------------------------------------------------------------------------------------------------------------%
% Pronanalazenje karakteristicnog polinoma (f)                                                                               %
%----------------------------------------------------------------------------------------------------------------------------%

f=det(A-x*eye(3));

%----------------------------------------------------------------------------------------------------------------------------%
% f1-prvi izvod funkcije f                                                                                                   %
% f2-drugi izvod funkcije f                                                                                                  %
%----------------------------------------------------------------------------------------------------------------------------%

f1=diff(f);
f2=diff(f1);

f=sym2poly(f);
f1=sym2poly(f1);
f2=sym2poly(f2);

format short;
Karakteristicni_polinom_koji_se_posmatra_je=0;
for i=1:length(f)
Karakteristicni_polinom_koji_se_posmatra_je=Karakteristicni_polinom_koji_se_posmatra_je+f(i)*x.^(length(f)-i);
end
Karakteristicni_polinom_koji_se_posmatra_je
format long;
%----------------------------------------------------------------------------------------------------------------------------%
% Pronalazenje nula prvog i drugog izvoda funkcije.(Ne posmatraju se kompleksne nule!                                        %  
%----------------------------------------------------------------------------------------------------------------------------%

n1=roots(f1);
j=1;
n3=[];
for i=1:length(n1)
    if isreal(n1(i))
      n3(j)=n1(i);
      j=j+1;
    end
end

n2=roots(f2);
n3=sort(n3);

if isempty(n3)
    nule=n2;
else
    nule=[n3 n2];
end

nule=sort(nule);

%----------------------------------------------------------------------------------------------------------------------------

a=nule(1);

h=0.1;
i=1;
k=1;

%----------------------------------------------------------------------------------------------------------------------------%
% Posmatra se interval [a-i*h,a] u slucaju da je f(a)<0                                                                      %
%----------------------------------------------------------------------------------------------------------------------------%
if ~isempty(n3)
    if polyval(f,n3(1))==0;
        disp('******************************************************************************************************************************')
        disp('******************************************************************************************************************************')
        fprintf('Kombinovani metod se ne moze primeniti na intervalima (-inf,A] i [A C]!\n(Zbog poredjenja sa eig uzeta je sopstvena vrednost: [%d %d])\n',n3(1),n3(1));
        sopstvena_vrednost(k)=a;
        sopstvena_vrednost(k+1)=a;
        k=k+2;
    end
end
%----------------------------------------------------------------------------------------------------------------------------%
if polyval(f,a)<0
    
    vrednostu_u_levom_kraju=polyval(f,a);
    levi_kraj=a;
    
    while vrednostu_u_levom_kraju<0
        vrednostu_u_levom_kraju=polyval(f,a-i*h);
        levi_kraj=a-i*h;
        i=i+1;
    end
    
    kkk=levi_kraj;
    
%----------------------------------------------------------------------------------------------------------------------------    

    if polyval(f1,levi_kraj)==0
        if sign(polyval(f,a))==sign(polyval(f,levi_kraj+50*eps))
            levi_kraj=levi_kraj-50*eps;
        else
            levi_kraj=levi_kraj+50*eps;
        end
    end

   tacka_newton=levi_kraj;
   tacka_secice=a;
           
%---------------------------------------------------------------------------------------------------------------------------- 

    while abs(tacka_newton-tacka_secice)>epsilon
          [tacka_newton tacka_secice]=kombinovani_metod(tacka_newton,tacka_secice,f,f1);
    end

    sopstvena_vrednost(k)=tacka_newton;
    
    k=k+1;
end

%----------------------------------------------------------------------------------------------------------------------------%
% Posmatra se interval [b,b*i+h] u slucaju da je f(b)>0                                                                      %
%----------------------------------------------------------------------------------------------------------------------------%

b=nule(length(nule));
i=1;

if ~isempty(n3)
    if polyval(f,n3(2))==0;
        disp('******************************************************************************************************************************')
        disp('******************************************************************************************************************************')
fprintf('Kombinovani metod se ne moze primeniti na intervalima [C B] i [B,inf)!\n(Zbog poredjenja sa eig uzeta je sopstvena vrednost: %d)\n',n3(2));

        sopstvena_vrednost(k)=b;
        k=k+1;
    end
end

if polyval(f,b)>0
    
    vrednostu_u_desnom_kraju=polyval(f,b);
    desni_kraj=b;
    
    while vrednostu_u_desnom_kraju>0
        vrednostu_u_desnom_kraju=polyval(f,b+i*h);
        desni_kraj=b+i*h;
        i=i+1;
    end
    
 kk=desni_kraj;
 
%---------------------------------------------------------------------------------------------------------------------------- 

    if polyval(f1,b)==0
        if sign(polyval(f,desni_kraj))==sign(polyval(f,b+50*eps))
           b=b-50*eps;
        else
            b=b+50*eps;
        end
    end
    
 %---------------------------------------------------------------------------------------------------------------------------- 
    tacka_newton=desni_kraj;
    tacka_secice=b;
        
    
    while abs(tacka_newton-tacka_secice)>epsilon
          [tacka_newton tacka_secice]=kombinovani_metod(tacka_newton,tacka_secice,f,f1);
    end

    sopstvena_vrednost(k)=tacka_newton;
    
    k=k+1;
end

%----------------------------------------------------------------------------------------------------------------------------%
% Ako postoje 3 podintervala ispituje se drugi podinterval [a,c] ako je ispunjen uslov f(a)*f(c)<0                           %
%----------------------------------------------------------------------------------------------------------------------------%

if length(nule)>1

if polyval(f,nule(2))==0
    disp('******************************************************************************************************************************')
    disp('******************************************************************************************************************************')
fprintf('Kombinovani metod se ne moze primeniti na intervalu [A,B] !\n(Zbog poredjenja sa eig uzeta je sopstvena vrednost: %d)\n',nule(2));

        sopstvena_vrednost(k)=nule(2);
        k=k+1;
end
            
if polyval(f,nule(1))*polyval(f,nule(2))<0
            
%----------------------------------------------------------------------------------------------------------------------------    
    if polyval(f1,tacka_newton)==0
        if sign(polyval(f,tacka_secice))==sign(polyval(f,tacka_newton+50*eps))
            tacka_newton=tacka_newton-50*eps;
        else
            tacka_newton=tacka_newton+50*eps;
        end
    end
%---------------------------------------------------------------------------------------------------------------------------- 
    if polyval(f,nule(1))*polyval(f2,nule(1))>0
            tacka_newton=nule(2);
            tacka_secice=nule(1);
    else 
            tacka_newton=nule(2);
            tacka_secice=nule(1);
    end   
%---------------------------------------------------------------------------------------------------------------------------- 
    
    while abs(tacka_newton-tacka_secice)>epsilon
          [tacka_newton tacka_secice]=kombinovani_metod(tacka_newton,tacka_secice,f,f1);
    end
       
    sopstvena_vrednost(k)=tacka_newton;
   
    k=k+1;
end

%----------------------------------------------------------------------------------------------------------------------------%
% Ako postoje 4 podintervala ispituje se treci podinterval [c,b] ako je ispunjen uslov f(c)*f(b)<0                           %
%----------------------------------------------------------------------------------------------------------------------------%

if length(nule)==3;  
    
%----------------------------------------------------------------------------------------------------------------------------   
if polyval(f,nule(2))*polyval(f,nule(3))<0
        
%---------------------------------------------------------------------------------------------------------------------------- 

    if polyval(f1,tacka_newton)==0
        if sign(polyval(f,tacka_secice))==sign(polyval(f,tacka_newton+50*eps))
            tacka_newton=tacka_newton-50*eps;
        else
            tacka_newton=tacka_newton+50*eps;
        end
    end
%---------------------------------------------------------------------------------------------------------------------------- 
      
    if  polyval(f,nule(2))*polyval(f2,nule(2))>=0
            tacka_newton=nule(2);
            tacka_secice=nule(3);
    else polyval(f,nule(3))*polyval(f2,nule(3))>0
            tacka_newton=nule(3);
            tacka_secice=nule(2);
    end
        
    while abs(tacka_newton-tacka_secice)>epsilon
           [tacka_newton tacka_secice]=kombinovani_metod(tacka_newton,tacka_secice,f,f1);
    end
       
    sopstvena_vrednost(k)=tacka_newton;
   
    k=k+1;
    
end
end
end

if isempty(n3) | polyval(f,nule)==0;
    sopstvena_vrednost=nule;
disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')
fprintf('Na datom primeru se ne moze primeniti kombinovani metod!\n(Zbog poredjenja sa eig uzeta je sopstvena vrednost: %d)\n',nule')
end

%----------------------------------------------------------------------------------------------------------------------------

Sopstvene_vrednosti_racunate_kombinovanom_metodom_su=sort(rot90(sopstvena_vrednost));

if isempty(Sopstvene_vrednosti_racunate_kombinovanom_metodom_su)
disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')
fprintf('Na datom primeru se ne moze primeniti kombinovani metod!\n')
else
     
disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')

Sopstvene_vrednosti_racunate_kombinovanom_metodom_su

A1=eig(A);
j=1;
for i=1:3
    if isreal(A1(i))
      B(j)=A1(i);
      j=j+1;
  end
end

B=sort(rot90(B));

disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')

Sopstvene_vrednosti_racunate_funkcijom_eig_su=B

disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')

Poredjenje_sa_funkcijom_eig=abs(B-Sopstvene_vrednosti_racunate_kombinovanom_metodom_su)
disp('******************************************************************************************************************************')
disp('******************************************************************************************************************************')

end

%----------------------------------------------------------------------------------------------------------------------------%
% GRAFICKI PRIKAZ                                                                                                            %
%----------------------------------------------------------------------------------------------------------------------------%
clf
iks=(nule(1)-1):0.001:(nule(length(nule))+1);
ipsilon=polyval(f,iks);
iks1=(nule(1)-1):0.001:(nule(length(nule))+1);
ipsilon1=polyval(f1,iks);
iks2=(nule(1)-1):0.001:(nule(length(nule))+1);
ipsilon2=polyval(f2,iks);
%----------------------------------------------------------------------------------------------------------------------------%
hold on;

if ~isempty(Sopstvene_vrednosti_racunate_kombinovanom_metodom_su)
plot(Sopstvene_vrednosti_racunate_kombinovanom_metodom_su,zeros(1,length(Sopstvene_vrednosti_racunate_kombinovanom_metodom_su)),'*','Color',[ 0.251 0.502 0.502 ])
end

if ~isempty(Sopstvene_vrednosti_racunate_funkcijom_eig_su)
plot(Sopstvene_vrednosti_racunate_funkcijom_eig_su,zeros(1,length(Sopstvene_vrednosti_racunate_funkcijom_eig_su)),'o')
end

P=nule;
if ~isempty(kkk)
P=[nule kkk];
end

if ~isempty(kk)
P=[P kk];
end
Title('\bf* * * KOMBINOVANI METOD * * *','FontSize',18,'Color',[0.7 0.1 0.1],'FontName','BernhardFashion BT')
plot(iks,ipsilon,'Color',[0.7 0.1 0.1])
text(iks(270),polyval(f,iks(250)),'\leftarrow f','HorizontalAlignment','left','Color',[0.7 0.1 0.1],'FontSize',18)
plot(iks1,ipsilon1,'Color',[0.1 0.7 0.1])
text(iks1(440),polyval(f1,iks1(450)),'\leftarrow f\prime','HorizontalAlignment','left','Color',[0.1 0.7 0.1],'FontSize',18)
plot(iks2,ipsilon2,'Color',[0.1 0.1 0.4])
text(iks2(655),polyval(f2,iks2(650)),'\leftarrow f\prime\prime','HorizontalAlignment','left','Color',[0.1 0.1 0.4],'FontSize',18)
plot(P,zeros(1,length(P)),'s','MarkerFaceColor',[0.992 0.800 0.859],'Color',[0.9 0.1 0.1],'LineWidth',2)
if ~isempty(kk)
    text(kk,-0.5,'\bf D','Color',[1 0 0])
end

if ~isempty(kkk)
    text(kkk,-0.5,'\bf L','Color',[1 0 0])
end

if ~isempty(n3)
    if n3(1)~=n3(2)
        text(n2,-0.5,'\bf C','Color',[1 0 0])
    end
end    

if ~isempty(n3)
    if n3(1)==n3(2)
        text(n3(1)-0.035,-0.5,'\bf A=B=C','Color',[1 0 0])
    else
        text(nule(1),-0.5,'\bf A','Color',[1 0 0])
        text(nule(3),-0.5,'\bf B','Color',[1 0 0])
    end
end

if length(nule)==1
    text(nule,-0.5,'\bf C','Color',[1 0 0])
end
    
plot(P,zeros(1,length(P)),'Color',[0.9 0.1 0.1])
plotedit on
grid on;
axis tight;
hold off;
legend('Sopstvene vrednosti dobijene kombinovanim metodom','Sopstvene vrednosti dobijene funkcijom eig','Funkcija karakteristicnog polinoma','Funkcija prvog izvoda karakteristicnog polinoma','Funkcija drugog izvoda karakteristicnog polinoma','Interval na kome se primenjuje kombinovani metod');

%----------------------------------------------------------------------------------------------------------------------------%