%Gaus_Zajdelova metoda 
function [resenje, broj_iter] = Gaus_Zajdel(A,b,x0,e)
% Zajdelovom metodom odredjuje priblizno resenje sistema sa zadatom tacnoscu e

nor = norm(A,inf);
red = length(b);

tacnost = ones(1,red).*( ((1-nor)/nor)*e );
provera = tacnost+1;  % da bi se uslo u while
x = zeros(1,red);

broj_iter = 0;
stara = x0; %
xn = x0;
resenje = xn;

while ( tacnost_zadovoljena(tacnost,provera) == 0)   
    % izracunavanje
    resenje = xn; 
    x(1) = xn*A(1,:)' + b(1);
    for i=2:red
        for j=1:i-1
            xn(j) = x(j);   % popravljanje koordinata tekuce iteracije na osnovu njenih vec izracunatih koordinata
        end
        x(i) = xn*A(i,:)' + b(i);
    end
    
    provera = abs( x-stara );
    broj_iter = broj_iter+1;
    stara = x;
    xn = x;
end
