% Funkcija koja izvrsava resavanje trodijagonalnog sistema AX=b linearnih
% algebarskih jednacina, Gausovom metodom
function X = resenje(A,b)
X = b;
n = size(A,1);
for i = 1:n-1
    koef = A(i+1,i)/A(i,i);
    A(i+1,:)=A(i+1,:)-A(i,:)*koef;
    % Sa elementima od I = 1 do n-1 elimini{emo one ispod njih jer  
    % postoje ne-nula elementi na (I+1,I)-tom mestu - ispod glavne
    % dijagonale 
    X(i+1)=X(i+1)-X(i)*koef;
end
for i = 0:n-2
    koef = A(n-i-1,n-i)/A(n-i,n-i);
    A(n-i-1,:)=A(n-i-1,:)-A(n-i,:)*koef;
    % Sa elementima od I = n do 2 elimini{emo samo one iznad njih jer su tu  
    % ne-nula elementi na (I-1,I)- tom mestu - iznad glavne dijagonale 
    X(n-i-1)=X(n-i-1)-X(n-i)*koef;
end
for i = 1:n
    % Na kraju ovim odre]ujemo vrednosti komponenti vektora re{enja zadatog
    % sistema jednacina
    X(i,1)=X(i,1)/A(i,i);
end 