%-------------------------------------------------------------------------------------------------------------------%
% INTERPOLACIJA LAGRAZEVIM INTERPOLACIONIM POLINOMOM AKO JE FUNKCIJA ZADATA TABLICNO                                % 
%-------------------------------------------------------------------------------------------------------------------%
% I   IZRACUNAVANJE KOEFICIJENATA LAGRANZEVOG INTERPOLACIONOG POLINOMA                                              %
% II  INVERZNA INERPOLACIJA                                                                                         %
% III GRAFIK                                                                                                        %
%-------------------------------------------------------------------------------------------------------------------%
% Korisnik bira nacin na koji ce uneti potrebne promenljive:                                                        %
%                                                                                                                   %
%  1- Ukoliko su cvorovi ekvidistantni                                                                              %                                       
%  2- Ukoliko cvorovi nisu ekvidistantni                                                                            %                                    
%     Ukoliko korisnik unese vrednost koja nije 1 ili 2 ispisuje se poruka o gresci!                                %                                  
%-------------------------------------------------------------------------------------------------------------------%
raspored=input('Ako su cvorovi interpolacije ravnomerno rasporedjeni unesi 1 a ako nisu 2: ');
%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko su cvorovi ekvidistantni                                                                                  %                                      
%-------------------------------------------------------------------------------------------------------------------%
if (raspored==1)
        a=input('Unesi pocetnu tacku intervala interpolacije: ');
        b=input('Unesi krajnju tacku intervala interpolacije: ');
        h=input('Unesi korak interpolacije: ');
%-------------------------------------------------------------------------------------------------------------------%
% Na osnovu unetih podataka formiraju se vektori vrse x i y                                                         %                                                            
%-------------------------------------------------------------------------------------------------------------------%
        x=a:h:b;
        y=input('Unesi vrednosti funkcije u zadatim cvorovima interpolacije: ');
%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko cvorovi nisu ekvidistantni                                                                                %
%-------------------------------------------------------------------------------------------------------------------%
else if (raspored==2) 
        x=input('Unesi cvorove interpolacije: ');
        y=input('Unesi vrednosti funkcije u zadatim cvorovima interpolacije: ');
%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko nije uneta vrednost nije ni 1 ni 2 ispisuje se poruka o gresci                                            %
%-------------------------------------------------------------------------------------------------------------------%
else    error('Uneti vrednost 1 ili 2!')
end 
end

X=input('Unesi tacke u obliku vektora vrste u kojima zelis da izracunas vrednost interpolacionog polinoma: ');

[mx,nx]=size(x);
[my,ny]=size(y);
[mX,nX]=size(X);

%-------------------------------------------------------------------------------------------------------------------%
% Provera korektrnosti unetih promenljivih                                                                          %
%-------------------------------------------------------------------------------------------------------------------%

if (mx~=1 | my~=1 | mX~=1)
    error('Argumenti bi trebalo da su vektori vrste!')
end
n=nx;
if ny~=n
    error('Vektori x i y bi trebalo da budu iste dimenzije')
end

if (~all(finite(x)))
    error('Vrednost svih cvorova bi trebalo da bude konacna')
end

if (~all(finite(y)))
    error('Vrednost funkcije u svim cvorovima bi trebalo da bude konacna')
end

if (length(x)~=length(unique(x)))
    error('Svi cvorovi interpolacije bi trebalo da budu razliciti')
end

%-------------------------------------------------------------------------------------------------------------------%
% IZRACUNAVANJE KOEFICIJENATA LAGRANZEVOG INTERPOLACIONOG POLINOMA                                                  %
%-------------------------------------------------------------------------------------------------------------------%

P=zeros(n,1); 

%-------------------------------------------------------------------------------------------------------------------%
% Prolazak kroz sve cvorove interpolacije                                                                           %
%-------------------------------------------------------------------------------------------------------------------%

for i=1:n
    
%-------------------------------------------------------------------------------------------------------------------%
% p je polinom koji ima nule u x1,...,xi-1,xi+1,...,xn tj. oblika: (x-x1)...(x-xi-1)(x-xi+1)...(x-xn)               %   
%-------------------------------------------------------------------------------------------------------------------%  
    p=poly(x(find([1:n]~=i)))';   
    
%-------------------------------------------------------------------------------------------------------------------%
% Vektor P predstavlja koeficijente Lagranzevog interpolacionog polinoma                                            %
%-------------------------------------------------------------------------------------------------------------------%
    P=P+p*y(i)/polyval(p,x(i));  
    
end

Koeficijenti_Lagranzevog_Interpolacionog_Polinoma=P

Vrednost_aproksimacije=polyval(P,X)

%-------------------------------------------------------------------------------------------------------------------%
%  INVERZNA INTERPOLACIJA                                                                                           %                                                   
%-------------------------------------------------------------------------------------------------------------------%

jot=input('Unesi vrednost u kojoj racunamo inverznu interpolaciju: ');

%-------------------------------------------------------------------------------------------------------------------%
% Posto je P vektor vrste vrsimo njegovo rotiranje cime postaje vektor kolone                                       %
%-------------------------------------------------------------------------------------------------------------------%

P_1=rot90(P);
dim=length(P_1);
Y_1=zeros(1,dim);
Y_1(dim)=jot;
P_1=P_1-Y_1;

%-------------------------------------------------------------------------------------------------------------------%
% Racunanje nula polinoma koji je nastao razlikom: f(x)-y ( f(x)=y => f(x)-y=0 )                                    %
%-------------------------------------------------------------------------------------------------------------------%
nule=roots(P_1);

%-------------------------------------------------------------------------------------------------------------------%
% Ispituje da li su nule polinoma realne i da li se nalaze na zadatom intervalu, ako je to ipunjeno formira se      %
% vektor vrste Inverzna_vrednost cuje su elementi trazene vrednosti tj. x-ovi za zadato y                           %
%-------------------------------------------------------------------------------------------------------------------%

j=1;
for i=1:length(nule)
    if ( isreal(nule(i)) & nule(i)>=x(1) & nule(i)<=x(length(x)) )
        Inverzna_vrednost(j)=nule(i);
        j=j+1;
        
    end
end

%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko ne postoji ni jedna nula polinoma ( f(x)-y=0 tj. P_1 ) j ce zadrzati vrednost 1 a vektor vrste            %  
% Inverzna_vrednost nece biti formiran pa se zato postavlja da je: Inverzna_vrednost=[] i ispisuje poruka           %
% da nema realnih nula na datom intervalu                                                                           %
%-------------------------------------------------------------------------------------------------------------------%

if (j==1)
    disp('Nema realnih nula na datom intervalu!')
    Inverzna_vrednost=[]
else

%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko postoji bar jedna nula formira se vektor Inverzna_vrednost i vrsi njegovo sortiranje                      %
%-------------------------------------------------------------------------------------------------------------------%

Inverzna_vrednost=sort(Inverzna_vrednost)

end
%-------------------------------------------------------------------------------------------------------------------%
% GRAFIK funkcije koja je zadata tablicno aproksimirane Lagranzevim interpolacionim polinomom                       %
%-------------------------------------------------------------------------------------------------------------------%

plot(x,y,'k-o')
xlabel('x');
ylabel('y');
title('Interpolacija Lagranzevim interpolacionim polinomom');

