%-------------------------------------------------------------------------------------------------------------------%
% INTERPOLACIJA LAGRAZEVIM INTERPOLACIONIM POLINOMOM AKO JE FUNKCIJA ZADATA EKSPLICITNO                             % 
%-------------------------------------------------------------------------------------------------------------------%
% I   IZRACUNAVANJE KOEFICIJENATA LAGRANZEVOG INTERPOLACIONOG POLINOMA                                              %
% II  PRIKAZ GRAFIKA GRESKE INTERPOLACIJE                                                                           %
% III INVERZNA INERPOLACIJA                                                                                         %
%-------------------------------------------------------------------------------------------------------------------%
% Korisnik bira nacin na koji ce uneti potrebne promenljive:                                                        %
%                                                                                                                   %
%  1- Ukoliko su cvorovi ekvidistantni                                                                              %                                       
%  2- Ukoliko cvorovi nisu ekvidistantni                                                                            %                                    
%     Ukoliko korisnik unese vrednost koja nije 1 ili 2 ispisuje se poruka o gresci!                                %                                  
%-------------------------------------------------------------------------------------------------------------------%
raspored=input('Ako su cvorovi interpolacije ravnomerno rasporedjeni unesi 1 a ako nisu 2: ');
%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko su cvorovi ekvidistantni                                                                                  %                                      
%-------------------------------------------------------------------------------------------------------------------%
if (raspored==1)
    a=input('Unesi pocetnu tacku intervala interpolacije: ');
    b=input('Unesi krajnju tacku intervala interpolacije: ');
    h=input('Unesi korak interpolacije: ');
%-------------------------------------------------------------------------------------------------------------------%
% Na osnovu unetih podataka formiraju se vektori vrse x i y                                                         %                                                            
%-------------------------------------------------------------------------------------------------------------------%
    x=a:h:b;
    y=myfun(x);
%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko cvorovi nisu ekvidistantni                                                                                %
%-------------------------------------------------------------------------------------------------------------------%
else if (raspored==2) 
    x=input('Unesi cvorove interpolacije: ');
    y=myfun(x);
%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko nije uneta vrednost nije ni 1 ni 2 ispisuje se poruka o gresci                                            %
%-------------------------------------------------------------------------------------------------------------------%
else error('Uneti vrednost 1 ili 2!')
end 
end

X=input('Unesi tacke u obliku vektora vrste u kojima zelis da izracunas vrednost interpolacionog polinoma: ');

[mx,nx]=size(x);
[my,ny]=size(y);
[mX,nX]=size(X);
%-------------------------------------------------------------------------------------------------------------------%
% Provera korektrnosti unetih promenljivih                                                                          %
%-------------------------------------------------------------------------------------------------------------------%

if (mx~=1 | my~=1 | mX~=1)
    error('Argumenti bi trebalo da su vektori vrste!')
end

n=nx;
if ny~=n
    error('Vektori x i y bi trebalo da budu iste dimenzije')
end

if (~all(finite(x)))
    error('Vrednost svih cvorova bi trebalo da bude konacna')
end

if (~all(finite(y)))
    error('Vrednost funkcije u svim cvorovima bi trebalo da bude konacna')
end

if (length(x)~=length(unique(x)))
    error('Svi cvorovi interpolacije bi trebalo da budu razliciti')
end
%-------------------------------------------------------------------------------------------------------------------%
% IZRACUNAVANJE KOEFICIJENATA LAGRANZEVOG INTERPOLACIONOG POLINOMA                                                  %
%-------------------------------------------------------------------------------------------------------------------%

P=zeros(n,1); 

%-------------------------------------------------------------------------------------------------------------------%
% Prolazak kroz sve cvorove interpolacije                                                                           %
%-------------------------------------------------------------------------------------------------------------------%

for i=1:n
%-------------------------------------------------------------------------------------------------------------------%
% p je polinom koji ima nule u x1,...,xi-1,xi+1,...,xn tj. oblika: (x-x1)...(x-xi-1)(x-xi+1)...(x-xn)               %   
%-------------------------------------------------------------------------------------------------------------------%

p=poly(x(find([1:n]~=i)))';
    
%-------------------------------------------------------------------------------------------------------------------%
% Vektor P predstavlja koeficijente Lagranzevog interpolacionog polinoma                                            %
%-------------------------------------------------------------------------------------------------------------------%
    P=P+p*y(i)/polyval(p,x(i));
end

Koeficijenti_Lagranzevog_Interpolacionog_Polinoma=P

%-------------------------------------------------------------------------------------------------------------------%
% Vrednost_aproksimacije - Cuva vrednosti aproksimacije Lagranzevim interpolacionim polinomom u zadatim tackama     %           
%-------------------------------------------------------------------------------------------------------------------%

Vrednost_aproksimacije=polyval(P,X)

f=myfun(X);

%-------------------------------------------------------------------------------------------------------------------%
% Racunanje greske interpolacije                                                                                    %
%-------------------------------------------------------------------------------------------------------------------%

Greska_Interpolacije=abs(f-Vrednost_aproksimacije) 

%-------------------------------------------------------------------------------------------------------------------%
% PRIKAZ GRAFIKA GRESKE : Posmatra se greska interpolacije u odnosu na broj cvorova na odredjenom intervalu.        % 
%                         Broj cvorova se krece od 4 do 10. Greska se posmatra u onim tackama u kojima              %    
%                         se vrsi racunanje vrednosti aproksimacije.                                                %   
%-------------------------------------------------------------------------------------------------------------------%


   broj=1;
   tacna_vr=myfun(X);
%-------------------------------------------------------------------------------------------------------------------%
% Broj grafika koji ce biti iscrtani zavisi od broja tacaka u kojima  vrsimo aproksimaciju Lagranzevim i.p.         %
%-------------------------------------------------------------------------------------------------------------------%
   kolonaX=nX;
   
   for l=1:kolonaX
   broj=broj+1;
   Y1=zeros(1,7);
   for t=3:9
   h=(x(n)-x(1))/t;
   q=x(1):h:x(n);
   r=myfun(q);
   [mq,nq]=size(q);
   g=nq;
   
   P1=zeros(g,1); 
   
%-------------------------------------------------------------------------------------------------------------------%
% U zavisnosti od broja cvorova(4,5,...,10 ) kojim delimo zadati inerval pravi se svakog puta Lagranzev i.p.        %
%-------------------------------------------------------------------------------------------------------------------%
for i=1:g
   
p1=poly(q(find([1:g]~=i)))';
P1=P1+p1*r(i)/polyval(p1,q(i));  
end

Y1(t-2)=Y1(t-2)+polyval(P1,(broj-1));
      
for i=1:7   
    Y1(i)=abs(Y1(i)-tacna_vr(broj-1));
end
end
   subplot(kolonaX+1,1,broj); plot([4 5 6 7 8 9 10],Y1,'r-o')
end

proba=x(1):0.001:x(n);
proba1=myfun(proba);
subplot(kolonaX+1,1,1);plot(x,y,'r-o',proba,proba1)
title('Grafici greske interpolacije (Lagrange)')

%-------------------------------------------------------------------------------------------------------------------%
%  INVERZNA INTERPOLACIJA                                                                                           %                                                   
%-------------------------------------------------------------------------------------------------------------------%

jot=input('Unesi vrednost u kojoj racunamo inverznu interpolaciju: ');

%-------------------------------------------------------------------------------------------------------------------%
% Posto je P vektor vrste vrsimo njegovo rotiranje cime postaje vektor kolone                                       %
%-------------------------------------------------------------------------------------------------------------------%

P_1=rot90(P);
dim=length(P_1);
Y_1=zeros(1,dim);
Y_1(dim)=jot;
P_1=P_1-Y_1;
%-------------------------------------------------------------------------------------------------------------------%
% Racunanje nula polinoma koji je nastao razlikom: f(x)-y ( f(x)=y => f(x)-y=0 )                                    %
%-------------------------------------------------------------------------------------------------------------------%
nule=roots(P_1);

%-------------------------------------------------------------------------------------------------------------------%
% Ispituje da li su nule polinoma realne i da li se nalaze na zadatom intervalu, ako je to ipunjeno formira se      %
% vektor vrste Inverzna_vrednost cuje su elementi trazene vrednosti tj. x-ovi za zadato y                           %
%-------------------------------------------------------------------------------------------------------------------%
j=1;
for i=1:length(nule)
    if ( isreal(nule(i)) & nule(i)>=x(1) & nule(i)<=x(length(x)) )
        Inverzna_vrednost(j)=nule(i);
        j=j+1;
        
    end
end
%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko ne postoji ni jedna nula polinoma ( f(x)-y=0 tj. P_1 ) j ce zadrzati vrednost 1 a vektor vrste            %  
% Inverzna_vrednost nece biti formiran pa se zato postavlja da je: Inverzna_vrednost=[] i ispisuje poruka           %
% da nema realnih nula na datom intervalu                                                                           %
%-------------------------------------------------------------------------------------------------------------------%
if (j==1)
disp('Nema realnih nula na datom intervalu!')
   Inverzna_vrednost=[]
else

%-------------------------------------------------------------------------------------------------------------------%
% Ukoliko postoji bar jedna nula formira se vektor Inverzna_vrednost i vrsi njegovo sortiranje                      %
%-------------------------------------------------------------------------------------------------------------------%

Inverzna_vrednost=sort(Inverzna_vrednost)
end