% INTERP1LAGRANGE interpolacija Lagranzevim interpolacionim polinomom
% Mora da sadrzi bar jedan cvor i svi cvorovi moraju biti razliciti
%
% Argumenti su :
%   x -  cvorovi interpolacije
%   y -  vrednosti funkcije u cvorovima
% Funkcija vraca :
% Y - Lagranzev i.p.

function Y=interp1Lagrange(x,y)
if nargin~=2 
    error('Ocekivana 2 argumenta!')
end


[mx,nx]=size(x);
[my,ny]=size(y);

if (mx~=1 | my~=1)
    error('Argumenti bi trebalo da su vektori vrste!')
end

n=nx;
if ny~=n
    error('Vektori x i y bi trebalo da budu iste dimenzije')
end

if (~all(finite(x)))
    error('Vrednost svih cvorova bi trebalo da bude konacna')
end

if (~all(finite(y)))
    error('Vrednost funkcije u svim cvorovima bi trebalo da bude konacna')
end

if (length(x)~=length(unique(x)))
    error('Svi cvorovi interpolacije bi trebalo da budu razliciti')
end


%Izracunavanje koeficijenata Lagranzevog i.p.

%vektor P predstavlja koeficijente Lagranzevog i.p.
P=zeros(n,1); 

%Prolazimo kroz sve cvorove interpolacije
for i=1:n
    %p je polinom koji ima nule u x1,...,xi-1,xi+1,...,xn, nema nulu samo u i  
    p=poly(x(find([1:n]~=i)))'; 
    %na Lagranzev i.p. se dodaje p*y(i)/p(xi) 
    P=P+p*y(i)/polyval(p,x(i));  
end

% vratimo Lagrnzev interpolacioni polinom :
Y=P;  


% koriscene f-je :
%           - size(x) <> vraca dimenziju vektora.
%           - lenght(x) == max(size(x)).
%           - finite(x) <> proverava da li su sve vrednosti f-je konacne.
%           - ZEROS(M,N) <> postavlja vrednosti na nula.
%           - poly(V) <> pravi polinom sa zadatim nulama
%           - X(find([1:n]~=i)) <> vektor uzimasve vrednosti osim i -te
%           - polyval(p,x) <> vrednost polinoma p u tackama x

%  primecene f-je:
%           - polyfit(x,y,n) <> nalazi koeficijente polinoma koji se slazu sa 
%           - roots(c)     <> nalzi korene polinoma ciji su koeficijenti c
