function L=coleski(A)
%COLESKI Izracunava matricu Coleski dekompozicije
%        realnog sisitema linearnih jednacina

n=size(A,1);

L(1,1)=sqrt(A(1,1));
for i=1:n
    L(i,1)=A(i,1)/L(1,1);
end
for i=2:n
    umanjilac=0;
    for k=1:i-1
        umanjilac=umanjilac+L(i,k)^2;
    end
    L(i,i)=sqrt(A(i,i)-umanjilac);
    for j=i+1:n
        umanjilac=0;
        for k=1:i-1
            umanjilac=umanjilac+L(i,k)*L(j,k);
        end
        L(j,i)=(A(j,i)-umanjilac)/L(i,i);
    end
end