% Napisati MatLAB program koji eksplicitno zadatu funkciju f tabelira na
% zadatom intervalu [a,b] sa korakom h=(b - a)/kn, k = 1,2,...,m
% (m je unapred zadat prirodan broj), a zatim za svako k formira odgovarajuci
% I Njutnov interpolacioni polinom. Za svaku vrednost k program treba da
% racuna pribliznu vrednost funkcije f u proizvoljnoj tacki x iz
% intervala [a,b] pomocu svih konstruisanih polinoma uz poredjenje dobijenih
% vrednosti sa tacnom vrednoscu f(x). Graficki prikazati.

clear;
close; % cicenje i zatvaranje zaostalih promenljivih i grafika

% Najpre tabeliramo f-ju

% unos podataka: f - funkcija; a,b - krajevi intervala; n - broj koraka;
% m - mnoilac
[f,a,b,n,m]=finkom;

% Sada formiramo k razlicitih (iks) vrsta u koje smetamo cvorove.
% Ocigledno, iz postavke samog zadatka imacemo k vrsta sa po k*n+1
% cvorova. Za formiranje k-tog polinoma bice nam neophodni i k-ti koraci
% tabeliranja, pa cemo da ih sacuvamo u odgovarajucu vrstu. U istoj petlji
% u kojoj formiramo Xk vrstu cvorova, formiramo i Yk vrstu vrednosti f-je
% u cvorovima. Nakon petlji oslobadjamo memoriju pomocne vrste, te
% brojaca i najmanjeg koraka tabeliranja

for k=1:m
    h=(b-a)./(k.*n); % formiramo korak tabeliranja za odgovarajuce k
    for i=1:k.*n+1   % ocigledno je da imamo kn+1 cvorova
        x(i)=a+(i-1).*h; % formiramo pomocnu vrstu sa iksevima
    end
    eval(['X' num2str(k) '=x;']) % Xk uzima vrednost x
    eval(['Y' num2str(k) '=eval(f);']); % vrednosti f-je po iksu ide u Yk
    clear x; % uklanjamo pomocnu vrstu
end

clear k, clear i, clear h; % uklanjamo brojace i najmanji korak

% Sledi unos konkretne tacke u kojoj elimo da aproksimiramo funkciju
taf=unos(a,b);

% Sada cemo da formiramo odgovarajuce tablice konacnih razlika. Naravno,
% tablice smo mogli odmah da napravimo u prethodnim petljama, ali bi to
% podrazumevalo da se one cuvaju u memoriji, to bi bilo strano
% neprakticno u slucajevima kada korisnik unese takve vrednosti mnoioca i
% broja koraka koje bi dovele do toga da imamo vie matrica sa trocifrenim
% dimenzijama. Na ovaj nacin, u memoriji ce se cuvati samo jedna pomocna
% tablica na osnovu koje cemo da formiramo traene polinome.

clc;
disp(['Interpolacija funkcije ' num2str(f) ' prvim Njutnovim polinomom u tacki ' num2str(taf) ':']);
disp('-------------------------------------');

% Sledi prikaz vrednosti prvog Njutnovog polinoma za razlicite vrednosti
% mnoioca koraka

for k=1:m
    vr_taf=eval(['PrviNjutn(taf, X' num2str(k) ', Y' num2str(k) ');']); % vrednost N1 u taf
    x=taf;
    vr=eval(f); % Stvarna vrednost funkcije u taf
    greska=abs(vr_taf-vr); % greka interpolacije
    disp(['Mnoilac koraka: k=' num2str(k) '.'])
    disp(['Vrednost prvog Njutnovog polinoma u ' num2str(taf) ' je: ' num2str(vr_taf) '.'])
    disp(['Vrednost funkcije ' num2str(f) ' u ' num2str(taf) ' je: ' num2str(vr) '.'])
    disp(['Greka interpolacije prvim Njutnovim polinomom je: ' num2str(greska) '.'])
    disp('-------------------------------------')
    clear x, clear vr, clear vr_taf, clear greska;
end

clear k;

% Sledi graficki prikaz ako korisnik tako eli
disp('Da li elite da vidite graficki prikaz interpolacije?')
odgovor=input('DA (1) / NE (inace): ');

if odgovor==1
    eval(['g=X' num2str(m) ';']); % najfinija podela intervala
    graf_matrica=zeros(m,length(g)); % matrica koju cemo da predstavimo na grafiku u funkciji od g
    for k=1:m
        eval(['x=X' num2str(k) ';']); % k-ta podela intervala
        eval(['y=Y' num2str(k) ';']); % odgovarajuce vrednosti u cvorovima
        for i=1:length(g)
            graf_matrica(k,i)=PrviNjutn(g(i),x,y);
        end
        clear i;
    end
    clear x, clear y, clear k;
    x=g; % zbog eval
    plot(g, eval(f), '.k', g, graf_matrica);
    grid;
    xlabel('Cvorovi najfinije podele');
    ylabel('Vrednosti polinoma i funkcije u cvorovima najfinije podele');
    legend('Grafik funkcije','Polinomi',-1);
end

disp(' ')
disp(' ')
disp('Nikola Nikica, 30i mart 2005e, Beograd')
disp(' ')
disp(' ')
clear; % cistimo kompletnu memoriju