
%Cukic Ivan 221/01
%Tekst zadatka:
%Napisati MatLab program koji za unapred zadatu funkciju f i brojeve a, b (a,b)
%priblizno racuna odredjeni integral date funkcije u zadatim granicama pomocu Sipsonove
%kvadraturne formule sa tacnoscu eps. Graficki uporediti rezultate sa rezultatima 
%dobijenim koriscenjem MatLAB funkcije quad za razlicite vrednosti eps.

% funkcija vrsi numericku integraciju koristeci 
% opstu Simpsonovu formulu i smanjuje duzinu intervala na
% koji primenjujemo Simp. for. dok se ne dobije trazena tacnost
%
% Ulazne velicine:
% a,b - granice odredjenog intervala
% E - tacnost koja se trazi u izracunavanju integrala  ( 1/2*10^E )

function NumInt(a,b,E)
tacnost=1/(2*10^E);
n=2;    
% Niz S sluzi za smestanje vrednosti integrala izracuntih Simp. for. 
% povecavajuci broj podintervala
% Izracunava se vrednost integrala Simp. formulom koristeci 2 intervala (3 tacke) 
S(1)=SimpsonFormula(a,b,n);
% pomocna promenljiva, koristi se za indeksiranje niza
i=1;
% R - greska izracunavanja, inicijalizuje se na +inf da bi program 
% uvek prosao kroz barem jednu iteraciju petlje
R=Inf;
% Dok nije zadovoljena trazena tacnost izracunava se Simps. form. 
% sa vecim brojem podintervala i greska koristeci Rungeovu ocenu greske
while (R >= tacnost)
    i=i+1;      %pomera se na sledece mesto u nizu
    %smanjuje se duzina intervala za pola, tj. uvecava se duplo broj intervala
    n=n*2;      
    %izracunava se integral Simp. form. za dati broj intervala
    S(i)=SimpsonFormula(a,b,n);
    %izracunava se greska Rungeovom metodom
    R=abs((S(i)-S(i-1))/(2^4-1));
end
%formiranje matrice dimenzija (2,length(S)) radi stampanja podataka u pravilnom formatu
j=1:i;
s=[2.^j+1; S];
%stampanje vrednosti integrala 
fprintf('Vrednosti Simpsonove for. za %d tacaka = %f\n',s)
fprintf('Vrednost integrala koja zadovoljava trazenu tacnost = %f\n', S(i))
%stampanje greske
fprintf('Greska metode = %e\n', R)
%broj cvorova koji je bio potreban da bi se postigla trazena tacnost
fprintf('Broj cvorova koji je bio potreban za postizanje trazene tacnosti = %d\n',2^i+1)

% graficki prikaz razlike vrednosti integrala dobijenih Simp. form. i 
% tacnih vrednosti dobijenih koriscenjem Matlab funkcije 'quad'
%
temp=S-quad('funkcija',a,b);
j=2.^(1:i);
bar(j,temp, 'r');
xlabel('Broj cvorova koriscenih u Simpsonovoj formuli');
title('Razlika integrala izracunatog Simpsonovom formulom i tacne vrednosti');
