#ifndef STRING_CONVERTER_H
#define STRING_CONVERTER_H

#include <string>

using namespace std;

class string_converter
{
    char* c_str;
    string cpp_str;
public:
    string_converter(const char* = "");
    string_converter(const string&);
    string_converter(const string_converter&);
    string_converter& operator=(const string_converter&);

#define COMPARE(op) bool operator op(const string_converter&) const;
    COMPARE(==)
    COMPARE(!=)
    COMPARE(<)
    COMPARE(>)
    COMPARE(<=)
    COMPARE(>=)
#undef COMPARE

    ~string_converter();
    void set(const char*);
    void set(const string&);
    const char* c_string() const;
    const string& cpp_string() const;
};

extern string_converter message;

#endif
