#ifndef JACOBI_H
#define JACOBI_H

#include <iostream>
#include <vector>

using namespace std;


typedef long double real;


#define DIGITS = 12
#define EPS 1e-12

class symmetric_matrix
{
	int ord;
	real **a;
	static real factor;

public:

	symmetric_matrix(int, real = 0);
	symmetric_matrix(const symmetric_matrix&);
	~symmetric_matrix();

	symmetric_matrix& operator=(const symmetric_matrix&);
	bool operator==(const symmetric_matrix&) const;
	bool operator!=(const symmetric_matrix&) const;

	int order() const;
	real& operator()(int, int);
	real norm2() const;
	vector<real> spectrum() const;

	friend ostream& operator<<(ostream&, symmetric_matrix&);
};

ostream& operator<<(ostream&, symmetric_matrix&);

#endif
