#include "string_converter.h"

string_converter::string_converter(const char *str)
{
    c_str = 0;
    set(str);
}

string_converter::string_converter(const string &str)
{
    c_str = 0;
    set(str);
}

string_converter::string_converter(const string_converter &s)
{
    c_str = 0;
    set(s.cpp_str);
}

string_converter::~string_converter()
{
    delete c_str;
}

string_converter& string_converter::operator=(const string_converter &s)
{
    set(s.cpp_str);

    return *this;
}

#define COMPARE(op)                                                     \
bool string_converter::operator op(const string_converter &s) const     \
{                                                                       \
    return (cpp_str op s.cpp_str);                                      \
}
    COMPARE(==)
    COMPARE(!=)
    COMPARE(<)
    COMPARE(>)
    COMPARE(<=)
    COMPARE(>=)
#undef COMPARE

void string_converter::set(const char *str)
{
    int i, n = strlen(str);

    delete c_str;
    c_str = new char[n+1];

    for (i=0; i<n; i++)
        c_str[i] = str[i];

    cpp_str = str;
}

void string_converter::set(const string &str)
{
    int i, n = str.size();

    cpp_str = str;
    delete c_str;
    c_str = new char[n+1];

    for (i=0; i<n; i++)
        c_str[i] = str[i];

    c_str[n] = 0;
}

const char* string_converter::c_string() const
{
    return c_str;
}

const string& string_converter::cpp_string() const
{
    return cpp_str;
}
