#include "input.h"

string sub_dir;

int get_int(istream &istr, int lower_bound, int upper_bound)
{
    int value;
    char ch;

    while(true)
    {
        istr >> ch;

        if (ch<'0' || ch>'9')
            cout << "Warning: Wrong input! Number required.\n" << endl;
        else
        {
            istr.putback(ch);

            break;
        }
    }


    while(true)
    {
        istr >> value;

        if (value>=lower_bound && value<=upper_bound)
            return value;
        else
            cout << "Warning: Wrong input! Try again. Proper values are "
                << lower_bound << "-" << upper_bound << "\n";
    }
}

#define MAX_FILENAME_PATH 1000

string_converter get_filename_open(string default_name, istream &input, ostream &output, bool interactive)
{
    char c_filename[MAX_FILENAME_PATH];
    string filename;
    FILE* f;

    while(true)
    {
        if (default_name.size()!=0)
            output << "[ default = " << default_name << " ] " << flush;

        input.getline(c_filename, MAX_FILENAME_PATH);
        filename = string(c_filename);

        if (filename.size()==0 && default_name.size()!=0)
            filename = default_name;

        string_converter conv(string("workspace/")+sub_dir+"/"+filename);
        f = fopen(conv.c_string(), "r");

        if (f==0)
            cout << "There is no file with name " << filename << "! Try agan.\n";
        else
        {
            fclose(f);

            return conv;
        }
    }
}

string_converter get_filename_create(string default_name, istream &input, ostream &output, bool interactive)
{
    char c_filename[MAX_FILENAME_PATH];
    string filename;
    FILE* f;

    while(true)
    {
        if (default_name.size()!=0)
            output << "[ default = " << default_name << " ] " << flush;

        input.getline(c_filename, MAX_FILENAME_PATH);
        filename = string(c_filename);

        if (filename.size()==0 && default_name.size()!=0)
            filename = default_name;

        string_converter conv(string("workspace/")+sub_dir+"/"+filename);
        f = fopen(conv.c_string(), "w");

        if (f==0)
            cout << "File with name " << filename << " can not be created! Try again.\n";
        else
        {
            fclose(f);

            return conv;
        }
    }
}
