#include <iostream>
#include <fstream>
#include <cstdlib>
#include <stdio.h>
#include "extensions.h"
#include "cliques.h"
#include "graph.h"

using namespace std;

enum choices {no_choice, extensions, cliques, isomorphisms, quit, wrong_choice};


void menu()
{
    while(true)
    {
        int choice;

        cout << "Menu\n\n\n";
        cout << "1. Computing the maximal extensions of the star complement\n";
        cout << "2. Computing the maximal cliques\n";
        cout << "3. Computing the isomorphism classes of the graphs\n";
        cout << "4. Exit program\n";
        cout << "\n\nChose 1-4 and hit ENTER\n\n";
        choice = get_int(cin, no_choice+1, wrong_choice-1);

        if (choice!=quit)
            cout << "\n\n";

        try
        {
            switch (choice)
            {
                case extensions:
                    maximal_extensions();
                    break;
                case cliques:
                    maximal_cliques();
                    break;
                case isomorphisms:
                    graph_isomorphisms();
                    break;
                case quit:
                    return;
            }
        }
        catch(const char *message)
        {
            cout << message << endl;
        }

        cout << "\n\n\n";
    }
}

int main()
{
    try
    {
        cout << "SCL - textual edition" << endl
             << "Copyright (c) by Zoran Stanic and Nedeljko Stefanovic." << endl
             << "This software is distributed under the version 2 of the" << endl
             << "GNU General Public License of the Free Software Foundation." << endl
             << "For more details, read the file COPYNG.txt." << endl << endl;

        menu();
    }
    catch(...)
    {
        cout << "Unexpected exception.\nPlease, report the bug to authors.\n";
    }

	return 0;
}
