%Tekst zadatka:
%Napisati MatLAB program koji za unetu matricu A i vektor b najpre proverava 
%regularnost matrice A, a zatim meodom LU dekompozicije resava sistem A*x=b dimenzije nxn.
%a) Uporediti dobijeno resenje sa resenjem dobijenim koriscenjem MatLAB funkcije lu(A).
%b) Na slucajan nacin izabrati 100 parova (An, bn), n=1,2,...,100 (An su matrice
%formata nxn, a bn kolona vektori duzine n) i resiti sisteme An*x=bn. Neka su xn i yn redom resenja
%dobijena gornjim programom i koriscenjem MatLAB operatora "\". Graficki prikazati zavisnost norme razlike
%resenja xn-yn, n=1,2,...,100 od mere uslovljenosti matrica An (program treba da izbaci iz razmatranja
%one matrice An koje su singularne).




function bojan3()
clc
format long

disp('******  COPYRIGHT Bojan Markovic (mr02163)  ******');
disp(' ');
disp('  Zadatak br.4  -- Sistemi linearnih jednacina --         '); 
disp(' ');
disp(' ');


A=input('Unesite matricu: ');
b=input('Unesite vektor: ');

[n,m]=size(A);
vec=length(b);

%provera slaganja
disp(' ');
if (n~=m)
    disp('Matrica mora biti kvadratna!');
    return
end

disp(' ');
if (n~=vec)
    disp('Dimenzije matrice i vektora se ne uklapaju!');
    return
end

%resenja
disp(' ');
disp('Uporedna resenja: ');
disp(' ');
disp('Uz pomoc LU() funkcije resenje sistema A*x=b je: ');
nase=LUfunkcija(A,b,n);
disp(nase);
disp(' ');
disp('Uz pomoc lu() funkcije resenje sistema A*x=b je: ');
[M,N,P]=lu(A);
komp=N\(M\(P*b));
disp(komp);


i=1;
while i<=100
 A=rand(n,n);
 b=rand(n,1);
 if det(A)~=0
  P=LUfunkcija(A,b,n);
  Tabela(1,i)=norm(A\b-P); %norma razlike 2 resenja 
  Tabela(2,i)=cond(A);     %uslovljenost matrice
  i=i+1;
 end
end

%sortiramo uslovljenosti matrica, koje ce biti na x osi  
for i=1:99
    for j=(i+1):100
        if Tabela(2,j) < Tabela(2,i)
            priv=Tabela(:,j);
            Tabela(:,j)=Tabela(:,i);
            Tabela(:,i)=priv;
        end
    end
end

%iscrtavanje grafa
line(H(2,:),H(1,:),'Color','r','LineWidth',1);
title('GRAF u zavisnosti od slucajno izabranih matrica');
xlabel('Uslovljenost matrice');
ylabel('Norma razlike resenja');



function P=LUfunkcija(A,b,n)

%dekompozicija
U=0;
for i=1:n
 U(1,i)=A(1,i);
 L(i,1)=A(i,1)./U(1,1);
end
for i=2:n
    for k=i:n
        PomSuma=0;
        for j=1:i-1
            PomSuma=PomSuma+L(i,j).*U(j,k);
        end
        U(i,k)=A(i,k)-PomSuma;
    end
    for k=i+1:n
        PomSuma=0;
        for j=1:i-1
            PomSuma=PomSuma+L(k,j).*U(j,i);
        end
        L(k,i)=(A(k,i)-PomSuma)./U(i,i);
    end
end

%resavanje sistema
P1=0;
for i=1:n
    PomSuma=0;
    for j=1:i-1
        PomSuma=PomSuma+L(i,j).*P1(j,1);
    end
    P1(i,1)=b(i,1)-PomSuma;
end

P=0;
for i=n:-1:1
    PomSuma=0;
    for j=n:-1:i+1
        PomSuma=PomSuma+U(i,j).*P(j,1);
    end
    P(i,1)=(P1(i,1)-PomSuma)./U(i,i);
end
