function xval=nelinjn2(epsmin,epsmax,epsstep,k)
%Tekst zadatka:Napisati MatLAB program koji
%a)metodom regula-falsi
%b)metodom secice
%nalazi priblizno resenje jednacine 0.1*sin(x) = x + 2 sa unapred zadatom tacnoscu eps.
%U oba slucaja graficki prikazati zavisnost brzine konvergencije od trazene tacnosti
%(Neka se na primer, eps krece od 0.0000001 do 0.001 sa korakom 0.0000004).
%Pod brzinom konvergencije se podrazumeva broj potrebnih iteracija za dobijanje resenja
%koje zadovoljava trazenu tacnost.
% NELINJN2, matlab implementacija drugog zadatka iz oblasti nelinearnih jednacina:
%           testiranje metoda regula falsi i secica na j-ni 
%  
%                            0.1*sin(x) = x + 2.
%
% Forma: xval=nelinjn2(epsmin,epsmax,epsstep,k)
%
%   Ulaznu parametri su:
%
%      EPSMIN  - Minimalna vrednost epsilon
%      EPSMAX  - Maksimalna vrednost epsilon
%      EPSSTEP - Korak testiranja vrednosti epsilon
%      K       - Metoda nad kojom se vrsi testiranje. 
%                  'a' - metoda regula falsu
%                  'b' - metoda secice
%      XVAL    - Vraca poslednju izracunatu pribliznu vrednost resenja jednacine.
%
%  Primer:
%
%   nelinjn2(0.00001,0.0001,0.00001,'a');
%

% sprecavanje nezeljenog ulaza
if k~='a' & k~='b'
    error('Cetvrti argument mora imati vrednost a ili b. Vidi help.');
end

% tacke intervala u kojem se nalazi nula
% mogu se menjati, ali samo pod uslovom da su zadovoljeni uslovi
% za izvodjenje metoda regula falsi i secice
a = -3;%-2.1;
b = -2;%-2.05;

% -- Priprema podataka ------------------------------------------------------------------

% racunanje apsolutnog minimuma prvog izvoda f-je
m1 = min(abs(0.1*cos(b)-1),abs(0.1*cos(a)-1));

% vektor broja iteracija potrebnih za postizanje zadovoljavajuce tacnosti
yvec = [];
% vektor vrednosti konstanti epsilon
xvec = [];
     
% -- Obrada podataka --------------------------------------------------------------------

% prolazenje svih vrednosti epsilona
for eps = epsmin:epsstep:epsmax
    
    % zadavanje pocetne tacke
    xvalprev = b;
    xval = a;
    niter = 2;

    % koriscenje odgovarajuce metode
    if(k=='a')
        %metod regula falsi
        while abs(f(xval)) > m1 * eps
            xval = xval - f(xval)*(b-xval)/(f(b)-f(xval));
            niter=niter+1;
        end
    else
        %metod secice
        while abs(f(xval)) > m1 * eps
            w = xval - f(xval)*(xvalprev-xval)/(f(xvalprev)-f(xval));
            xvalprev = xval;
            xval = w;
            niter=niter+1;
        end
    end

    yvec = [yvec,niter,niter];
    xvec = [xvec,eps,eps+epsstep];
end


% -- Crtanje grafika --------------------------------------------------------------------

plot(xvec,yvec,'r-');

% Generisanje naslova slike
text = ['Metoda '];
if k=='a'
    text = [text 'regula falsi'];
else
    text = [text 'secica'];
end
text = [text ': zavisnost broja iteracija od' 10 ...
        'epsilon pri resavanju j-ne 0.1sin(x)=x+2'];
title(text);

% Nazivanje osa
xlabel(' epsilon');
ylabel(' broj iteracija');

clear xvec yvec niter xval xvalprev w m1 a b text eps;

% Autor: (mr02117) Mihajlo Andjelkovic, 19.05.2004.