function [funkcija, pocetak_intervala, kraj_intervala, broj_koraka, mnozilac]=finkom

% Ime funkcije od: *F*unkicija *IN*terval *KO*rak *M*noilac.
%
% Ova funkcija slui za unos osnovnih podataka:
%
% - funkcije koju interpoliramo,
%   - unos prihvata string bez apostrofa
%
% - krajeva intervala
%   - proverava se ispravnost unosa (pocetak_intervala < kraj_intervala)
%
% - broja koraka
%   - ponavlja se sve do unosa celog broja
%
% - mnoioca za viestruko tabeliranje.
%   - ponavlja se sve do unosa celog broja
%
% F-ja na kraju izdaje osnovne podatke.

clc;
funkcija=input('Unesite funkciju koju elite da interpolirate.\nKoristite x kao nezavisnu promenljivu: ', 's');

pocetak_intervala=input('\nUnesite pocetak intervala: ');

while 1
    kraj_intervala=input('\nUnesite kraj intervala: ');
    if kraj_intervala > pocetak_intervala
        break;
    elseif kraj_intervala < pocetak_intervala
        disp(' ');
        disp('Kraj intervala je manji od pocetka!');
        disp('Vrim zamenu vrednosti!');
        pom=pocetak_intervala;
        pocetak_intervala=kraj_intervala;
        kraj_intervala=pom;
        clear pom;
        break;
    else
        disp('Pocetak i kraj intervala su jednaki!');
        disp('Molim Vas unesite ispravne podatke!');
    end
end

while 1
    broj_koraka=input('\nUnesite broj koraka: ');
    if (round(broj_koraka)-broj_koraka==0) & (~isnan(broj_koraka)) & (isfinite(broj_koraka))
        broj_koraka=abs(broj_koraka); % elimo pozitivnu vrednost
        break;
    else 
        disp('Molim Vas, unesite ceo broj!');
    end
end

while 1
    mnozilac=input('\nUnesite mnoilac koraka: ');
    if (round(mnozilac)-mnozilac==0) & (~isnan(mnozilac)) & (isfinite(mnozilac))
        mnozilac=abs(mnozilac); % elimo pozitivnu vrednost
        break;
    else 
        disp('Molim Vas, unesite ceo broj!');
    end
end

home;
disp(' ')
disp(['Vrimo interpolaciju funkcije ' num2str(funkcija) ' na intervalu [ ' num2str(pocetak_intervala) ' , ' num2str(kraj_intervala) ' ].'])
disp(['Najmanji korak za tabeliranje funkcije je: ' num2str((kraj_intervala-pocetak_intervala)./(mnozilac.*broj_koraka)) '.'])
