% Olivera Mazulovic 01/072


%Tekst zadatka:
%Neka je funkcija f(x) zadata eksplicitno ili tablicno
%na intervalu [a, b]. Napisati MatLAB  program koji, koristeci Lagranzov
%interpolacioni polinom priblizno
%racuna vrednost prvog i drugog izvoda funkcije u
%proizvoljnoj tacki intervala [a, b] uz izracunjavanje greske.
%Takodje, program treba da omogucava nalazenje priblizne vrednosti x za koje je
%f'(x) i f''(x) zadato. Graficki prikazati.




% Koristenjem Lagranzovog interpolacionog polinoma program nalazi 
% vrednosti prvog i drugog izvoda u zadatoj tack
% Program izracunava vrednost funkcije i njen prvi i drugi izvod u zadatoj tacki

function lagrange(vrfunk, st, t, inv,red_izvoda)
% Funkcija koja na osnovu unetih argumenata poziva odredjene funkcije
% vrfunk --- ima vrednost 'exp' ili 'tab' u zavisnosti
%            da li interpoliramo funkciju zadatu eksplicitno ili tablicom
% st --- stepen Lagranzevog interpolacionog polinoma
% t --- vrednost za koju zelimo da interpoliramo
% inv --- argument koji ima vrednost 'da' ako je t=f(x) i zelimo da nadjemo x (inverzna interpolacija)
% ako je inv == 'da' onda se navodi i red_izvoda
% red_izvoda --- ima vrednost 0,1,2

if nargin < 3
    interpoliraj(vrfunk,st);
else if nargin < 4
        interpoliraj(vrfunk, st, t);
    else if nargin==4
            red_izvoda=0;
        end
            inverz(vrfunk,st,t,red_izvoda); % inverzno ne radi!!!
    end    
end

        
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function vrednost=interpoliraj(vrfunk,st,t)
% Funkcija za pozivanje odgovarajucih funkcija
% ako je zadata vrednost t onda se poziva funkcija polinom
% koja nalazi Lagranzev int. polinom stepena st za vrednost t
% ako nije zadata vrednost t onda se poziva samo funkcija za graficko prikazivanje 
% ako je upitanju inverzna interpolacija poziva se odgovarajuca funkcija


if vrfunk=='tab'
        tablica1;
    else
        tablica;
        y=eval(imefunkcije);
        I=diff(imefunkcije);
        II=diff(I);
    end
if nargin>2    
    [x,y]=interval(x,y,st,t);
    Ln = polinom(x,y,st);
    val=polyval(Ln,t);
    
    [R_val,R] = greska(Ln,x,y,t);
    [val1,R1_val,Ln1,R1]=izvod(Ln,R,t);
    [val2,R2_val,Ln2,R2]=izvod(Ln1,R1,t);    
    
    if vrfunk=='tab'
        
        sprintf('Ln(%0.4g)=%0.4g   R(%0.4g)=%0.4g\nLn`(%0.4g)=%0.4g   R(%0.4g)=%0.4g\nLn``(%0.4g)=%0.4g   R(%0.4g)=%0.4g',t,val,t,R_val,t,val1,t,R1_val,t,val2,t,R2_val)
        prikazi_tab(Ln,x,y,st,t,val);
        
    else
        prikazi_exp(Ln,x,y,st,imefunkcije,t,val);
        x=t;
        y=eval(imefunkcije);
        y1=eval(I);
        y2=eval(II);
        R_val=abs(val-y);
        R1_val=abs(val1-y1);
        R2_val=abs(val2-y2);
        sprintf('f(%0.4g)=%0.4g   Ln(%0.4g)=%0.4g   R(%0.4g)=%0.4g\nf`(%0.4g)=%0.4g   Ln`(%0.4g)=%0.4g   R(%0.4g)=%0.4g\nf``(%0.4g)=%0.4g  Ln``(%0.4g)=%0.4g   R(%0.4g)=%0.4g',t,y, t,val, t,R_val,  t,y1, t,val1, t,R1_val,  t,y2, t,val2, t,R2_val)
    end
else
    Ln=polinom(x,y,st);
    if vrfunk=='tab'
        prikazi_tab(Ln,x,y,st);
    else
        prikazi_exp(Ln,x,y,st,imefunkcije);
    end
end

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function Ln=polinom(x, y, st)     
% Nalazenje Lagranzevog interpolacionog polinoma za st+1 cvor ukoliko st nije
% vece od maksimalnog broja cvorova

n=min(st+1, max(size(x)));

Ln=0;
syms X;
for i=1:n
    Pn=1;
    for j=1:n
        if i~=j
              Pn=Pn*(X-x(j))/(x(i)-x(j));
          end
      end
    Ln=Ln+Pn*y(i);
end
Ln=sym2poly(Ln);

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function [R_val,R] = greska(Ln,x,y,t)
% funkcija za odredjivanje greske Lagranzeve interpolacije
% funkcija vraca vrednost greske za zadatu tacku i formulu za 
% gresku koja se dalje koristi za nalazenje greske izvoda


n=max(size(Ln));
Ln_val=polyval(Ln,t);
syms X
if t~=x(1:end)      % ako je t razlicita od cvorova
    pro=1;
    for k=1:n
        pro=pro*(X-x(k));     % nalazenje omega(X)=(X-x1)...(X-xk)
        end
    R=podeljene([x t],[y Ln_val])*pro;% greska se nalazi preko podeljenih razlika
    R=sym2poly(R);
    R_val=abs(polyval(R,t));
    
else
    R=0;
    R_val=0;
end

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function [val1, R1_val, Ln1, R1] = izvod(Ln, R, t)
% funkcija koja nalazi izvod polinoma i greske i izracunava njihove vrednosti

    
    Ln1=sym2poly(diff(poly2sym(Ln)));
    R1=sym2poly(diff(poly2sym(R)));
    
    val1=polyval(Ln1,t);
    R1_val=abs(polyval(R1,t));


%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function prikazi_exp(Ln_poly,x,y,st,funkcija,x0,y0)
% prikazivanje eksplicitno zadate funkcije

x_cv=x;
y_cv=y;

a=x(1);
b=x(min(st+1, max(size(x))));

x=a:.1:b;
y_poly=polyval(Ln_poly,x);

x=a-.3:.1:b+.3;
f=eval(funkcija);

plot(x,f,'-b', a:.1:b, y_poly, '-r', 'LineWidth', 2);
grid on
hold on

plot(x_cv, y_cv, 'o', 'MarkerFaceColor', 'g', 'MarkerSize', 7);
if nargin>5
    hold on
    plot(x0,y0, 'o','MarkerFaceColor', 'm', 'MarkerSize', 7);
    legend(funkcija, 'Lagranzev polinom', 'Cvorovi', 'Trazena tacka',0);
else
    legend(funkcija, 'Lagranzev polinom', 'Cvorovi',0);
end
hold off

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function prikazi_tab(Ln_poly,x,y,st,x0,y0)
% prikazivanje tablicno zadate funkcije

x_cv=x;
y_cv=y;

a=x(1);
b=x(min(st+1, max(size(x))));

x=a:.1:b;
y_poly=polyval(Ln_poly,x);

plot(a:.1:b, y_poly, '-r', 'LineWidth', 2);
grid on
hold on
plot(x_cv, y_cv, 'o', 'MarkerFaceColor', 'g', 'MarkerSize', 7);
if nargin>4
    hold on
    plot(x0,y0, 'o','MarkerFaceColor', 'm', 'MarkerSize', 7);
    legend('Lagranzev polinom', 'Cvorovi', 'Trazena tacka',0);
else
    legend('Lagranzev polinom', 'Cvorovi',0);
end
hold off

%===============================================================================

function inverz(vrfunk, st, vred, red_izvoda)
% Funkcija okrece tablicu, a onda sortira po y,
% zatim nalazi interval u kome je funkcija monotona i onda
% poziva funkciju za nalazenje Lagranzevog interpolacionog polinoma

if vrfunk=='tab'
        tablica1;
    else
        tablica;
        y=eval(imefunkcije);
    end

x_st=x;
y_st=y;

M=[y;x];
M=sortrows(M',1);       % sortiranje po y
M=M';
y=M(1,:);
x=M(2,:);

n=max(size(x));
r=1;
if vred<y(end)
    while r<n & vred>y(r)   r=r+1;   end
    if r>1
        r=r-1; s=r+1; k=-1;
        if x(r)>x(s)
            s=r; r=r+1; k=1;
        end
        while r<=n & r+k<=n & r>0 & r+k>0 & x(r-1)<x(r)    r=r+k;  end
        k=-k;
        while s<=n & s+k<=n & s>0 & s+k>0 & x(s)<x(s+k)    s=s+k;  end
        if r<s
            y=y(r:s);
            x=x(r:s);
        else
            y=y(s:r);
            x=x(s:r);
        end

        [x,y]=interval(x_st,y_st,st,vred);
        Ln = polinom(x,y,st);
        val=polyval(Ln,vred);
        
        [R_val,R] = greska(Ln,x,y,vred);
        if red_izvoda>=1 
            [val,R_val,Ln1,R1]=izvod(Ln,R,vred);
        end
        if red_izvoda==2
            [val,R_val,Ln2,R2]=izvod(Ln1,R1,vred);
        end
  
        if red_izvoda==0 
            sprintf('Ln(%0.4g)=%0.4g   R=%0.4g',val,vred,R_val)
        else if red_izvoda==1
                sprintf('Ln`(%0.4g)=%0.4g   R=%0.4g',val,vred,R_val)
            else if red_izvoda==2
                    sprintf('Ln``(%0.4g)=%0.4g   R=%0.4g',val,vred,R_val)
                end
            end
        end
            
           
        if vrfunk=='tab'
            prikazi_tab(Ln,x,y,st,val,vred);
        else
            prikazi_exp(Ln,x,y,st,imefunkcije,val,vred);
        end
        
    end

end


%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function [x,y] = interval(x,y,st,t)
% interval je funkcija koja nalazi odgovarajuci interval cvorova
% ukoliko je n stepen trazenog polinoma manji od broja tacaka
% potrebno je izabrati n+1 cvor tako da se trezena vrijednost
% nadje negdje izmedju tih cvorova

br_cv=max(size(x));
if ((st+1) < br_cv) & (t <= x(end)) & (t >= x(1))  
    i=1;
    while t>x(i)
        i=i+1;
    end
    i=i-1;
    j=floor((st+1)/2);
    k=st+1-j;
    if i-j<1
        pocetak=i;
        while pocetak>1
            j=j-1;
            pocetak=pocetak-1;
        end
        kraj=pocetak+st+1;
    else
        if i+k>br_cv
            kraj=i;
            while kraj<br_cv
                k=k-1;
                kraj=kraj+1;           
            end
            pocetak=kraj-st-1;
    
        else
            pocetak=i-j;
            kraj=pocetak+st+1;
            x=x(pocetak:kraj);
            y=y(pocetak:kraj);
        end
    end
end

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function pod = podeljene(x,y)
% Funkcija sluzi za nalazenje podeljene razlike elemenata zadatih u x
% sa vrednostima funkcije u tim tackama u y
% Funkcija u ovom programu iskljucivo sluzi za nalazenje greske

n=max(size(x));

for i=1:n
    for j=1:n
        M(i,j)=x(i)-x(j);
    end
    M(i,i)=1;
end
M=prod(M');         % ovo su vrednosti prvog izvoda funkcije omega(x)
                    % tj M(k)=(xk-x1)...(xk-x(k-1))(xk-x(k+1))...(xk-xn)
pod=0;
for i=1:n
        pod=pod+y(i)/M(i);
end

