function [KFPravougaonika,KFTrapeza,KFSimpsona]=kv(a,b,n)

% Formula pravougaonika

 h=(b-a)/(n+2);
 P1=0;
 
for i=0:n/2
   x=a+(2*i+1)*h;
   P1=P1+ myfunf(x);
end
KFPravougaonika=2*h*P1;

% Formula trapeza

h=(b-a)/n;
T0=myfunf(a)+myfunf(b);
T1=0;

for i=1:n-1
   x=a+i*h;
   T1=T1+myfunf(x);
end
KFTrapeza=h*(T0+2*T1)/2;

% Simpsonova formula

h=(b-a)/n;
S0=myfunf(a)+myfunf(b);
S1=0;
S2=0;

for i=1:n-1
   x=a+i*h;
   if mod(i,2)==0
      S2=S2+myfunf(x);
   else
      S1=S1+myfunf(x);
   end
end
KFSimpsona=h*(S0+2*S2+4*S1)/3;
