function resi_sistem()

A = input('Unestite matricu sistema.\nA = ');
b = input('Unesite kolonu slobodnih clanova.\nb = ');
e = input('Unesite tacnost sa kojom zelite rezultat.\ne = ');

while ( det(A)==0 | dijag_domin(A)==0 )   
    if (det(A)==0 )                      % ako matrica nije regularna
        A = input('Matrica sistema je singularna. Unesite regularnu matricu.');    
    end
    if ( dijag_domin(A)==0 )             % ako matrica nije dijagonalno dominantna
        A = input('Matrica nije dijagonalno dominantna. Unesite ponovo. A = '); 
    end
end
 
[B,c] = transf_u_norma_manja_od_jedan(A,b);
[resenje, broj_iter] = prosta_iter(B,c,c',e);
disp('Prosta iteracija:   ');
ispis(resenje,broj_iter);
[resenje, broj_iter] = Gaus_Zajdel(B,c,c',e);
disp('Gaus-Zajdel:   ');
ispis(resenje,broj_iter);

% graficki prikaz zavisnosti brzine konvergencije (broj iteracija potrebnih za nalazenje pribliznih resenja )
% od tacnosti e u oba slucaja (e se menja od 0.001 do 0.000001 sa korakom
% 0.000002) -uslov zadatka
in = 1;  %indeks
niz = zeros(3,in);  %vektor kolona sa tri elementa,koje su 0
for e=0.000001:0.000002:0.001
    [resenje, P_br_iter] = prosta_iter(B,c,c',e);
    [resenje, Z_br_iter] = Gaus_Zajdel(B,c,c',e);
    niz(1,in) = e;  %pravi se niz
    niz(2,in) = P_br_iter;
    niz(3,in) = Z_br_iter;
    in = in+1;
end

plot(niz(1,:),niz(2,:),'--r',niz(1,:),niz(3,:),'-.b');
legend('Metod proste iteracije','Gaus-Zajdelov metod');
xlabel('tacnost (e)','FontSize',8)
ylabel('broj iteracija','FontSize',8)
title('Zavisnost broja iteracija od zadate tacnosti','FontSize',12)
clear all;

%--------- ispis -----------
function ispis(resenje,broj_iter)

disp('resenje:  ')
disp(resenje);
disp('broj iteracija:  ');
disp(broj_iter);