%Metoda proste iteracije
function [resenje,broj_iter] = prosta_iter(A,b,x0,e)
% odredjuje priblizno resenje sistema sa zadatom tacnoscu e

nor = norm(A,inf);  %norma matrice
red = length(b);   %duzina vectora kolone

tacnost = ones(1,red).*( ((1-nor)/nor)*e );
provera = tacnost+1;  % da bi se uslo u while
x = zeros(1,red);

x = x0*A' + b';  %transponovano zbog kolone
xn = x;  %tacka kojoj tezi iteracija
provera = abs( x-x0 );% uslov zaustavljanja
broj_iter = 1; % broj iteracija

while ( tacnost_zadovoljena(tacnost,provera) == 0 ) %ponavljanaje iteracija
    xn = x;
    x = xn*A' + b';   %pisem x*A'+b=0, a ne A*x+b=0, da bih radio sa vrstama-vektorima, ne sa kolonama!
    provera = abs( x-xn );
    broj_iter = broj_iter+1;
end

resenje = xn;% resenje
broj_iter = broj_iter-1;% ukupan broj iteracija