function []=domaci3(tacnost)
%posmatramo posebno f-je f(x)=x.^2+x-2 i h(x)=log(x)
%na osnovu njihovih grafika poznato nam je da se ove f-je seku u tacno dve tacke
%koje ce i biti resenja polazne jednacine
%takodje pravimo ocenu da se jedno resnje nalazi na intervalu [0.1 0.4]
%a drugo na [0.75 1.25]
%proveravamo:
%F(0.1)=0.412
%F(0.4)=-0.523 tj ispunjen je uslov da je f-ja F na krajevima intevala suprotnih znakova
%Prvi izvod funkcije F(x) je F'(x)=2*x+1-1./x, i on je opadajuci na
% intervalima (0,0.5) i za vrednosti x koje su manje od -1, pa nas segment ocigledno upada
%u interval (0,0.5) 
inter1(1)=0.1;
inter1(2)=0.4;
inter1(3)=0.412;
inter1(4)=-0.523;
% Posto je izvod opadajuca funkcija na [0.1 0.4], minimum  
% izvoda po apsolutnoj vrednosti na intervalu [0.1 0.4] je u tacki 0.4, tj.
M1=8.8;
% , a maksimum  izvoda na intervalu [0.1 0.4] je u tacki 0.1, tj.
m1=0.7;
%takodje nam je neophodan i drugi izvod f-je F,a to je 
%F"(x)=2+1./x^2,on je ocigledno pozitivan za svako x razlicito od 0
% u svakom slucaju F" je konstantnog znaka i  na [0.1 0.4] i na [0.75 1.25]
%vrednost drugog izvoda u krajevima pomenutih intervala 
%F"(0.1)=102 a F"(0.4)=8.25
inter1(5)=102;
inter1(6)=8.25;
[Resenja(1,1) i]=RegulaFalsi(inter1,tacnost,M1,m1);
[Resenja(1,2) j]=Secica(inter1,tacnost,M1,m1);
%na analogan nacin vrsimo proracune i za drugi interval
% f(0.75)=-0.39981<0
% f(1.25)=0.58935>0
inter2(1)=0.75;
inter2(2)=1.25;
inter2(3)=-0.39981;
inter2(4)=0.58935;
% pa je i f(0.75)*f(1.25)<0, tako da je sigurno da se jedno resenje nalazi na (0.75,1.25)
% Prvi izvod funkcije F(x) je F'(x)=2*x+1-1./x, i on je rastuci na
% intervalu (0.75,1.25), a posto je 
% f'(0.75)=1.16667 >0 i
% f'(1.25)=2.70000 >0
% i  cela funkcija f'(x) je >0 na intervalu (0.75,1.25)
% Posto je izvod rastuca funkcija, minimum izvoda na intervalu (0.75,1.25) je
% u tacki 0.75, tj.
m2=1.16667;
%, a maksimum izvoda na intervalu (0.75,1.25) je u tacki 1.25, tj.
M2=2.70000;
%vec je utvrdjeno za drugi izvod da je pozitivan na celom intervalu,a vrednosti su
%F"(0.75)=3.77778
%F"(1.25)=2.64000
inter2(5)=3.77778;
inter2(6)=2.64000;
[Resenja(2,1) k]=RegulaFalsi(inter2,tacnost,M2,m2);
[Resenja(2,2) l]=Secica(inter2,tacnost,M2,m2);
disp(' ')
disp('     Regula Falsi       Secica')
disp(Resenja)
disp('            Potreban broj iteracija')
fprintf('               %i               %i\n',i ,j)
fprintf('                %i                %i ',k,l)

%grafik zavisnosti brzine konvergencije od trazene tacnosti
q=1;
for korak=1.0e-7:4.0e-7:1.0e-3
    [R i]=RegulaFalsi(inter1,korak,M1,m1);
    Regf(q)=i;
    T(q)=korak;
    q=q+1;
end
plot(T,Regf,'r','LineWidth',2)
grid on
title('Grafik zavisnosti brzine konvergencije od trazene tacnosti')
ylabel('Broj iteracija potrebnih za dobijanje resenja')
xlabel('Tacnost')
hold on
g=1;
for korak=1.0e-7:4.0e-7:1.0e-3
    [R j]=Secica(inter1,korak,M1,m1);
    Sec(g)=j;
    T(g)=korak;
    g=g+1;
end
plot(T,Sec,'LineWidth',2)
hold off



