
%Tekst zadatka:
% Napisati MatLAB  program koji zadatu funkciju oblika 
%f(x)=1/(A+Bx^2), A, B>0,  tabelira na zadatom intervalu
%[-a, a] sa korakom h=2a/n, a zatim
%konstruise Lagranzov interpolacioni polinom L1(x) stepena n
%koriscenjem dobijenih vrednosti (xi, f(xi)), i=0,1, ..., n 
%(cvorovi su -a=x0<x1<...<xn=b) i Lagranzov
%interpolacioni polinom L2(x), takodje n-tog stepena, 
%koriscenjem vrednosti (xi', f(xi')), i=0,1, ..., n,
% gde su novi cvorovi xi' nule Cebisevljevog polinoma
%T(x) stepena n+1 na intervalu [-a, a]. Program treba omoguci
%izracunavanje priblizne vrednosti funkcije f u
%proizvoljnoj tacki intervala [-a, a] pomocu oba
%konstruisana polinoma, kao i poredjenje dobijenih rezultata sa
%tacnim resenjem. Na istom grafiku prikazati funkciju f i polinome
%L1(x) i L2(x)




% unosimo parametar A
greska = 1;
while greska == 1
    A = input( 'Unesite parametar A: ' );
    if length( A ) > 1
        disp( 'Neispravan unos !!!' )
    elseif A <= 0
        disp( 'Parametar A mora biti pozitivan !!!' )
    else
        greska = 0;
    end
end
% unosimo parametar B
greska = 1;
while greska == 1
    B = input( 'Unesite parametar B: ' );
    if length( B ) > 1
        disp( 'Neispravan unos !!!' )
    elseif B <= 0
        disp( 'Parametar B mora biti pozitivan !!!' )
    else
        greska = 0;
    end
end
% unosimo parametar a
greska = 1;
while greska == 1
    a = input( 'Unesite parametar a (interval je [-a, a]): ' );
    if length( a ) > 1
        disp( 'Neispravan unos !!!' )
    elseif a == 0
        disp( 'Parametar a mora biti razlicit od nule !!!' )
    elseif a < 0
        disp( 'Parametar a je negativan, pa cemo uzeti -a !!!' )
        a = -a;
        greska = 0;
    else
        greska = 0;
    end
end
% unosimo parametar n
greska = 1;
while greska == 1
    n = input( 'Unesite parametar n (stepen interpolacionog polinoma): ' );
    if length( n ) > 1
        disp( 'Neispravan unos !!!' )
    elseif n <= 0 | abs( n - round( n ) ) > eps
        disp( 'Parametar n mora biti pozitivan prirodan broj !!!' )
    else
        greska = 0;
    end
end

% Konstruisimo polinome L1 i L2
x1 = linspace( -a, a, n+1 );
y1 = VrednostFunkcije( A, B, x1 );

x2 = CebisevljeveNule( a, n+1 );
y2 = VrednostFunkcije( A, B, x2 );

disp( 'Lagranzov polinom sa cvorovima u ekvidistantnim tackama: ' )
L1 = LagranzovPolinom( x1, y1 )
disp( 'Lagranzov polinom sa cvorovima u Cebisevljevim nulama: ' )
L2 = LagranzovPolinom( x2, y2 )

% Iscrtajmo grafik
CrtajGrafik( L1, L2, A, B, a )

% Izracunavanja
kraj = 1;
while kraj ~= 0
    disp( 'Unesite:' )
    disp( '0 - za kraj' )
    disp( '1 - za izracunavanja' )
    disp( '2 - za prikaz prvog polinoma' )
    disp( '3 - za prikaz drugog polinoma' )
    kraj = input( 'Opcija: ' );
    if kraj == 0
        return
    elseif kraj == 1
        % unosimo tacku u kojoj zelimo da interpoliramo
        greska = 1;
        while greska == 1
            x = input( 'Unesite tacku u kojoj zelite da interpolirate: ' );
            if length( x ) > 1
                disp( 'Neispravan unos !!!' )
            elseif x < -a | x > a
                disp( '' )
                disp( 'Upozorenje: Tacka je van intervala, radimo ekstrapolaciju !!!' )
                greska = 0;
            else
                greska = 0;
            end
        end
        % racunamo vrednosti
        vrednost = VrednostFunkcije( A, B, x )
        vrednost1 = polyval( L1, x );
        vrednost2 = polyval( L2, x );
        greska1 = abs( vrednost1 - vrednost );
        greska2 = abs( vrednost2 - vrednost );
        par1 = [vrednost1 greska1]
        par2 = [vrednost2 greska2]
    elseif kraj == 2
        L1
    elseif kraj == 3
        L2
    else
        error( 'Neodgovarajuca opcija !!!' )
    end
end