% Ana Kojic 130/01
%Tekst zadatka:
%Napisati MatLab program koji za unapred zadatu funkciju f i brojeve a, b (a,b)
%priblizno racuna odredjeni integral date funkcije u zadatim granicama pomocu Sipsonove
%kvadraturne formule sa tacnoscu eps. Graficki uporediti dobijenu vrednost sa tacnom
%vrednoscu odredjenog integrala

function intergracija
% program pomocu Trapezne kvadadraturne formule izracunava integral
% proizvoljne funkcije u datim granicama sa postepenim povecavanjem cvorova (2,3,...)
% sve dok se ne zadovolji tacnost
% svi ulazni podaci su smjesteni u m-fajlu "podaci"

    podaci;
    i=2;
    R=tacnost+1;
    while  R > tacnost
        [S1,h1]=formula(i);
        [S2,h2,cvoroviX,cvoroviY]=formula(i+1);
        R=greska(S1,h1,S2,h2);
        i=i+1;
    end
    povrsina=S2
    tacna_povrsina=quad(funkcija,a,b)  
    greska=R
    korak=h2
    broj_cvorova=i+1
    nacrtaj(cvoroviX,cvoroviY);
      

function [S,h,cvoroviX,cvoroviY] = formula ( br_cv )
% trapezna kvadraturna formula

    podaci;
    h=(b-a)/br_cv;
    x=a;
    y=eval(funkcija);
    suma=y;
    cvoroviX=[x];
    cvoroviY=[y];
    for i=1:br_cv-1
        x=a+i*h; y=eval(funkcija);
        cvoroviX=[cvoroviX,x];
        cvoroviY=[cvoroviY,y];
        suma=suma+2*y;
    end
    x=b;
    suma=suma+eval(funkcija);
    S=h/2*suma;
    cvoroviX=[cvoroviX,x];
    cvoroviY=[cvoroviY,y];

    
function R = greska( S1, h1, S2, h2)
% Rungeov metod za procjenu greske

    R=abs((S2-S1)/((h1/h2)^2-1));
    

function nacrtaj(X,Y)    
% prikazivanje povrsine dobijene trapeznom integracijom i funkcije

    area(X,Y,'FaceColor',[.9 .9 .9])
    grid on
    title 'Povrsina ispod funkcije'
    hold on
    for i=1:max(size(X))    
         area(X(i),Y(i));
         hold on
    end
    
    podaci;
    x=a:.1:b;
    y=eval(funkcija);
    f=sprintf('f(x)=%s',funkcija);
    plot(x,y, '-r','LineWidth', 2)
    legend(f,0)
    hold off