using namespace std;

#include <string>
#include <fpu_control.h>
#include <math.h>
#include <stdio.h>
#include "nm.cpp"

int main(int argc, char **argv)
{
    fpu_control_t oldcw, newcw;
    _FPU_GETCW(oldcw); newcw = (oldcw & ~_FPU_EXTENDED) | _FPU_DOUBLE; _FPU_SETCW(newcw);
    Graph *ga, *gb;
    NMSimilarity *s;
    double eps;
    double similarity;
    if(argc<3) {
      printf("Two input graphs are needed.\n");
      exit(1);
    }
    if(argc<4)
	eps=0.0001;
    else
	eps=atof(argv[3]);
    
    try
    {
	ga=new Graph(argv[1]);
    }
    catch(...)
    {
	return -1;
    }

    try
    {
	gb=new Graph(argv[2]);
    }
    catch(...)
    {
	return -1;
    }

    s=new NMSimilarity(ga,gb);
    
    printf("\nNumber of iterations: %d\n", s->Iterate(eps,100000));
    printf("\nSimilarity matrix:\n\n");
    similarity=0;
    for(int i=0; i<ga->NodeCount(); i++)
    {
	printf(" [ ");
	for(int j=0; j<gb->NodeCount(); j++)
	  printf("%lf ", s->NodeSimilarity(i,j));
	printf("]\n");
    }

    printf("\n");
    
    delete s;
    delete ga;
    delete gb;
    return 0;
}
