
#include <string>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "graph.cpp"
#include <iostream>

#define INF 0x7fffffff

class NMSimilarity
{
private:
    double **node_similarity;
    double **tmp_similarity;
    Graph *graph_a;
    Graph *graph_b;
    int graph_a_n;
    int graph_b_n;
    double epsilon;
    long *solution;
    long *costs;
    int first_time;
    
    int Iteration(double eps)
    {
	int precision_achieved=1;
	for(int i=0; i<graph_a_n; i++)
	    for(int j=0; j<graph_b_n; j++)
		tmp_similarity[i][j]=node_similarity[i][j];
	for(int i=0; i<graph_a_n; i++)
	    for(int j=0; j<graph_b_n; j++)
	    {
		if(graph_a->Label(i)!=graph_b->Label(j))
		    continue;
		vector<int>::iterator kaddr,laddr;
		int klen, llen;
		double in_similarity=0;
		double out_similarity=0;
		graph_a->EnumBeginningEdges(i,&kaddr,&klen);
		graph_b->EnumBeginningEdges(j,&laddr,&llen);
    		if(klen>0 && llen>0)
		{
		    costs=(long *)malloc(klen*llen*sizeof(long));
		    solution=new long[klen];
		    for(int k=0; k<klen; k++)
    			for(int l=0; l<llen; l++)
		    	    costs[k*llen+l]=(1-tmp_similarity[graph_a->TerminatingNode(kaddr[k])][graph_b->TerminatingNode(laddr[l])])/eps;
			
		    hungarian(&costs, klen, llen, solution, 0);
		    for(int k=0; k<klen; k++)
			if(solution[k]>=0)
			    out_similarity+=tmp_similarity[graph_a->TerminatingNode(kaddr[k])][graph_b->TerminatingNode(laddr[solution[k]])];
		    delete solution;
		    free(costs);
		}
		if(max(klen,llen)!=0)
		  out_similarity/=(max(klen,llen));
		else
		  out_similarity=1;

		graph_a->EnumTerminatingEdges(i,&kaddr,&klen);
		graph_b->EnumTerminatingEdges(j,&laddr,&llen);
		if(klen>0 && llen>0)
		{
		    costs=(long *)malloc(klen*llen*sizeof(long));
		    solution=new long[klen];
		    for(int k=0; k<klen; k++)
    			for(int l=0; l<llen; l++)
		    	    costs[k*llen+l]=(1-tmp_similarity[graph_a->SourceNode(kaddr[k])][graph_b->SourceNode(laddr[l])])/eps;
		    hungarian(&costs, klen, llen, solution, 0);			
		    for(int k=0; k<klen; k++)
			if(solution[k]>=0)
			    in_similarity+=tmp_similarity[graph_a->SourceNode(kaddr[k])][graph_b->SourceNode(laddr[solution[k]])];
		    delete solution;
		    free(costs);
		}
		if(max(klen,llen)!=0)
		  in_similarity/=(max(klen,llen));
		else
		  in_similarity=1;

		node_similarity[i][j]=(in_similarity+out_similarity)/2;
		if(fabs(tmp_similarity[i][j]-node_similarity[i][j])>=eps)
		    precision_achieved=0;
	    }
	return precision_achieved;
    }
    void Clear()
    {
	for(int i=0; i<graph_a_n; i++)
	    delete node_similarity[i];
	delete node_similarity;
	for(int i=0; i<graph_a_n; i++)
	    delete tmp_similarity[i];
	delete tmp_similarity;
    }
    
public:
    NMSimilarity(Graph *gr_a, Graph *gr_b): graph_a(gr_a), graph_b(gr_b)
    {
	first_time=1;
	Reload(gr_a,gr_b);
	first_time=0;
    }
    void Reload(Graph *gr_a, Graph *gr_b)
    {
	if(!first_time)
	    Clear();
	graph_a=gr_a;
	graph_b=gr_b;
	graph_a_n=graph_a->NodeCount();
	graph_b_n=graph_b->NodeCount();
	node_similarity=new double*[graph_a_n];
	tmp_similarity=new double*[graph_a_n];
	for(int i=0; i<graph_a_n; i++)
	{
	    node_similarity[i]=new double[graph_b_n];
	    for(int j=0; j<graph_b_n; j++)
	      node_similarity[i][j]=graph_a->Label(i)==graph_b->Label(j);
	    tmp_similarity[i]=new double[graph_b_n];
	}
    }
    ~NMSimilarity()
    {
	Clear();
    }
    int Iterate(double eps, int max_iter)
    {
	int iter=0;
	int it=0;
	while(!it && iter<max_iter)
	{
	    it=Iteration(eps);
	    iter++;
	}	
	return iter;
    }
    double NodeSimilarity(int i, int j)
    {
	if(i>=graph_a_n || j>=graph_b_n)
	    return -1;
	return node_similarity[i][j];
    }

static int hungarian(long **mtx, int m, int n, long *solution, long heur)
{
    long *col_mate;
    long *row_mate;
    long *parent_row;
    long *unchosen_row;
    long t;
    long q;
    long *row_dec;
    long *col_inc;
    long *slack;
    long *slack_row;
    long unmatched;
    
    long *tmtx;
    long transposed;

    register long k;
    register long l;
    register long j;
    register long s;
    
    assert(*mtx);
    assert(m);
    assert(n);
    
    if (m != n)
	heur = 0;

    if (m > n) {
	tmtx = (long *) malloc(m * n * sizeof(long));
	if (tmtx == NULL) {
	    fprintf(stderr, "Hungarian algorithm: Sorry, out of memory!\n");
	    exit(-1);
	}
	for (k = 0; k < m; k++)
	    for (l = 0; l < n; l++)
		*(tmtx + l * m + k) = *(*mtx + k * n + l);
	m = n;
	n = k;
	free(*mtx);
	*mtx = tmtx;
	transposed = 1;
    } else
	transposed = 0;



    col_mate = (long *) malloc(m * sizeof(long));
    row_mate = (long *) malloc(n * sizeof(long));
    parent_row = (long *) malloc(n * sizeof(long));
    unchosen_row = (long *) malloc(m * sizeof(long));
    row_dec = (long *) malloc(m * sizeof(long));
    col_inc = (long *) malloc(n * sizeof(long));
    slack = (long *) malloc(n * sizeof(long));
    slack_row = (long *) malloc(n * sizeof(long));

    if (!col_mate || !row_mate || !parent_row || !unchosen_row || !row_dec
	|| !col_inc || !slack || !slack_row) {
	fprintf(stderr, "Hungarian algorithm: Sorry, out of memory!\n");
	exit(-1);
    }

    if (heur) {
	for (l = 0; l < n; l++) {
	     s = (*mtx)[0*n+l];
	    for (k = 1; k < n; k++)
		if ( (*mtx)[k*n+l] < s)
		    s = (*mtx)[k*n+l];
	    if (s != 0)
		for (k = 0; k < n; k++)
		     (*mtx)[k*n+l] -= s;
	}
    }

    t = 0;
    for (l = 0; l < n; l++) {
	 row_mate[l] = -1;
	 parent_row[l] = -1;
	 col_inc[l] = 0;
	 slack[l] = INF;
    }
    for (k = 0; k < m; k++) {
	 s = (*mtx)[k*n+0];
	for (l = 1; l < n; l++)
	    if ( (*mtx)[k*n+l] < s)
		s = (*mtx)[k*n+l];
	 row_dec[k] = s;
	for (l = 0; l < n; l++)
	    if (( s == (*mtx)[k*n+l]) && ( row_mate[l] < 0)) {
		 col_mate[k] = l;
		 row_mate[l] = k;
		goto row_done;
	    }
	 col_mate[k] = -1;
	 unchosen_row[t++] = k;
      row_done:;
    }

    if (t == 0)
	goto done;
    unmatched = t;
    while (1) {
	q = 0;
	while (1) {
	    while (q < t) {


		{
		     k = unchosen_row[q];
		     s = row_dec[k];
		    for (l = 0; l < n; l++)
			if ( slack[l]) {
			    register long del;
			     del = (*mtx)[k*n+l] - s + col_inc[l];
			    if (del < slack[l]) {
				if (del == 0) {
				    if ( row_mate[l] < 0)
					goto breakthru;
				     slack[l] = 0;
				     parent_row[l] = k;
				     unchosen_row[t++] = row_mate[l];
				} else {
				     slack[l] = del;
				     slack_row[l] = k;
				}
			    }
			}
		}

		q++;
	    }


	    s = INF;
	    for (l = 0; l < n; l++)
		if ( slack[l] && slack[l] < s)
		    s = slack[l];
	    for (q = 0; q < t; q++)
		 row_dec[unchosen_row[q]] += s;
	    for (l = 0; l < n; l++)
		if ( slack[l]) {
		     slack[l] -= s;
		    if (slack[l] == 0) {
			 k = slack_row[l];
			if ( row_mate[l] < 0) {
			    for (j = l + 1; j < n; j++)
				if ( slack[j] == 0)
				     col_inc[j] += s;
			    goto breakthru;
			} else {
			     parent_row[l] = k;
			     unchosen_row[t++] = row_mate[l];
			}
		    }

		} else
		     col_inc[l] += s;

	}
      breakthru:

	while (1) {
	     j = col_mate[k];
	     col_mate[k] = l;
	     row_mate[l] = k;
	    if (j < 0)
		break;
	     k = parent_row[j];
	    l = j;
	}

	if (--unmatched == 0)
	    goto done;


	t = 0;
	for (l = 0; l < n; l++) {
	     parent_row[l] = -1;
	     slack[l] = INF;
	}
	for (k = 0; k < m; k++)
	    if ( col_mate[k] < 0) {
		 unchosen_row[t++] = k;
	    }

    }
  done:

    for (k = 0; k < m; k++)
	for (l = 0; l < n; l++)
	    if ((*mtx)[k*n+l] < row_dec[k] - col_inc[l]) {
		printf("%d %d\n",m,n);
		for(int o=0; o<m; o++)
		{
		    for(int u=0; u<n; u++)
			printf("%ld ",(*mtx)[o*n+u]);
		    putchar('\n');
		}
		putchar('\n');
		fprintf(stderr, "Hungarian algorithm: Oops, I made a mistake!\n");
		exit(-1);
		return -6;
	    }
    for (k = 0; k < m; k++) {
	l = col_mate[k];
	if (l < 0 || (*mtx)[k*n+l] != row_dec[k] - col_inc[l]) {
	    fprintf(stderr, "Hungarian algorithm: Oops, I blew it!\n");
	    exit(-1);
	    return -66;
	}
    }
    k = 0;
    for (l = 0; l < n; l++)
	if (col_inc[l])
	    k++;
    if (k > m) {
	fprintf(stderr, "Hungarian algorithm: Oops, I adjusted too many columns!\n");
	exit(-1);
	return -666;
    }

    if (!transposed)
	memcpy(solution, col_mate, m * sizeof(long));
    else
    {
	for (k = 0; k < n; k++)
	    solution[k]=-1;
	for (k = 0; k < m; k++)
	    solution[col_mate[k]] = k;
    }

    free(col_mate);
    free(row_mate);
    free(parent_row);
    free(unchosen_row);
    free(row_dec);
    free(col_inc);
    free(slack);
    free(slack_row);

    return 0;
}

};
