dataset = load('dataset.txt');

mu_k = 0.03; % korak ucenja
num_iter = 1000; % broj iteracija optimizacionog metoda

metaparams = [0.001, 0.01, 0.1, 1]; % skup odakle kasnije biramo najbolji metaparametar

% Evaluacija nekonfigurabilnog algoritma
% koristeci Training-Test evaluaciju
disp('=-=-=-=-=-=-=-=-=-=-=-=-=-=-=');
disp('TRENING-TESTIRANJE');
disp('=-=-=-=-=-=-=-=-=-=-=-=-=-=-=');

dataset = standardize(dataset);
dataset = [ones(size(dataset, 1), 1) dataset];
X = dataset(:,1:end-1);
y = dataset(:,end);

% Model
w = train(X, y, 0)

% Ocena njegove greske
err = eval_tt(X, y, ...
                @(X,y) train(X, y, 0), ...
                @(y, f_w) loss(y, f_w), ... % f_w predstavlja izracunatu vrednost
                @(X, w) predict(X, w));
                     
fprintf(1, 'Greska: %f\n', err);

fprintf('\n');

% Evaluacija nekonfigurabilnog algoritma
% koristeci unakrsnu validaciju
disp('=-=-=-=-=-=-=-=-=-=-=-=-=-=-=');
disp('UNAKRSNA VALIDACIJA');
disp('=-=-=-=-=-=-=-=-=-=-=-=-=-=-=');

% Model
w = train(X, y, 0)

% Ocena njegove greske
err = eval_cv(X, y, ...
                @(X, y) train(X, y, 0.2), ...
                @(y, f_w) loss(y, f_w), ...
                @(X, w) predict(X, w));

fprintf(1, 'Greska: %f\n', err);

fprintf('\n');

% Evaluacija konfigurabilnog algoritma koristeci
% train-validation-test evaluaciju
disp('=-=-=-=-=-=-=-=-=-=-=-=-=-=-=');
disp('TRENING-VALIDACIJA-TESTIRANJE');
disp('=-=-=-=-=-=-=-=-=-=-=-=-=-=-=');

% Model
meta = select_tt(X, y, @(X, y, la) train(X, y, la), @(y, h) loss(y, h), @(X, w) predict(X, w), metaparams);
w = train(X, y, meta)

% Ocena njegove greske
err = eval_tvt(X, y, ...
              @(X, y, la) train(X, y, la), ...
              @(y, f_w) loss(y, f_w), ...
              @(X, w) predict(X, w), ...
              metaparams);
                           
fprintf(1, 'Greska: %f\n', err);

fprintf('\n');

% Evaluacija konfigurabilnog algoritma koristeci
% ugnezdenu unakrsnu evaluaciju
disp('=-=-=-=-=-=-=-=-=-=-=-=-=-=-=');
disp('UGNEZDENA UNAKRSNA VALIDACIJA');
disp('=-=-=-=-=-=-=-=-=-=-=-=-=-=-=');

% Model
meta = select_cv(X, y, @(X, y, la) train(X, y, la), @(y, h) loss(y, h), @(X, w) predict(X, w), metaparams);
w = train(X, y, meta)

% Ocena njegove greske
err = eval_ncv(X, y, ...
              @(X, y, la) train(X, y, la), ...
              @(y, f_w) loss(y, f_w), ...
              @(X, w) predict(X, w), ...
              metaparams);
                           
fprintf(1, 'Greska: %f\n', err);

fprintf('\n');

