function err = eval_tvt(X, y, fn_train, fn_loss, fn_predict, metaparams)
% Funkcija koja vrsi evaluaciju konfigurabilnog algoritma u odnosu na najbolji metaparametar

    n = length(y);
	% train_ind bez obzira na naziv predstavlja uniju trening skupa i skupa za testiranje.
    [train_ind, test_ind] = dividerand(1:n, 0.8, 0.2);
    
    X_train = X(train_ind, :);
    y_train = y(train_ind, :);

    X_test = X(test_ind, :);
    y_test = y(test_ind, :);

	% Vrsimo izbor najboljeg meta parametra nad trening skupom. Kako funkcija select_tt
	% ulazni skup posmatra kao kompletan skup i deli ga na trening i test deo, to sto
	% ona izabere za test skup mi posmatramo kao validacioni skup.
    best_meta = select_tt(X_train, y_train, fn_train, fn_loss, fn_predict, metaparams);
    
	% Treniramo model nad zbirno trening i validacionim skupom. Predikciju i procenu
	% greske radimo nad skupom za testiranje.
    w = fn_train(X_train, y_train, best_meta);
    f_w = fn_predict(X_test, w);
    err = fn_loss(y_test, f_w);
    err = mean(err);
end
