function err = eval_tt(X, y, fn_train, fn_loss, fn_predict)
% Funkcija koja vrsi evaluiranje modela na osnovu podele na trening i test skup

    n = length(y);
	% Nasumicno uzimamo indekse iz intervala [1,n] u razmeri 7:3
    [train_ind, test_ind] = dividerand(1:n, 0.7, 0.3);

	% Uzimamo trening skup na osnovu izabranih trening indeksa
    X_train = X(train_ind, :);
    y_train = y(train_ind, :);

	% Uzimamo test skup na osnovu izabranih test indeksa
    X_test = X(test_ind, :);
    y_test = y(test_ind, :);

	% Treniramo model nad podacima za treniranje
    w = fn_train(X_train, y_train);
    
	% Vrsimo predikciju i procenu greske na test skupu
    f_w = fn_predict(X_test, w);
    err = fn_loss(y_test, f_w);
    err = mean(err);
end
