function err = eval_ncv(X, y, fn_train, fn_loss, fn_predict, metaparams)
% Funkcija koja ugnezdjenom unakrsnom validacijom vrsi procenu kvaliteta modela.

    n = length(y);
    K = 10;
    f_w = zeros(n,1);    
    
    ind = crossvalind('KFold', n, K);
    for i = 1:K
        X_train = X(ind ~= i, :);
        y_train = y(ind ~= i);
        
        X_test = X(ind == i, :);
        
		% Najbolji meta parametar biramo unakrsnom validacijom.
        best_meta = select_cv(X_train, y_train, fn_train, fn_loss, fn_predict, metaparams);
        
		% Treniranje i predikciju vrsimo sa ovim metaparametrom, ali ocenu greske ne vrsimo
		% pri svakom foldu vec cemo na kraju izracunati ukupnu gresku.
        w = fn_train(X_train, y_train, best_meta);
        f_w(ind==i) = fn_predict(X_test, w);
    end

    err = fn_loss(y, f_w);
    err = mean(err);
end
    
