function err = eval_cv(X, y, fn_train, fn_loss, fn_predict)
% Funkcija koja vrsi evaluaciju modela unakrsnom validacijom (cross validation)

    n = length(y);
    K = 10;
    f_w = zeros(n,1);
    
	% delimo skup podataka velicine n u K celina
    ind = crossvalind('KFold', n, K);

	% iteriramo po celinama, za svaku treniramo model i vrsimo samo predvidjanja
	% dok ocenu greske ostavljamo za kasnije kako bismo izbegli optimisticnu ocenu.
    for i = 1:K
        X_train_K = X(ind ~= i, :);
        y_train_K = y(ind ~= i);
        
        X_test_K = X(ind == i, :);
        
        w_K = fn_train(X_train_K, y_train_K);
        f_w(ind==i) = fn_predict(X_test_K, w_K);
    end
    
    err = fn_loss(y, f_w);
    err = mean(err);
end
