function plot_decision_boundary(w, X, y)
plot_data(X(:,2:3), y);
hold on
if size(X, 2) <= 3
    plot_x = [min(X(:,2))-2,  max(X(:,2))+2];
    plot_y = (-1./w(3)).*(w(2).*plot_x + w(1));
    plot(plot_x, plot_y)
	xlabel('Exam 1 score')
	ylabel('Exam 2 score')
    legend('Admitted', 'Not admitted', 'Decision Boundary')
    axis([30, 100, 30, 100])
else
    u = linspace(-1, 1.5, 50);
    v = linspace(-1, 1.5, 50);

    z = zeros(length(u), length(v));
    for i = 1:length(u)
        for j = 1:length(v)
            z(i,j) = map_feature(u(i), v(j))*w;
        end
    end
    z = z';
    contour(u, v, z, [0, 0], 'LineWidth', 2);
end
hold off

end
