% Ucitavaju se podaci.
data = load('dataset.txt');
fprintf(1, 'Loaded dataset of size:\n');
disp(size(data));

% Postavljaju se parametri.
mu = 0.0001;                % korak ucenja
iterations = 2000000;       % broj iteracija za gradijentni spust
reg = 'l1';                 % tip regularizacije, l1 ili l2
lambda = 0.1;               % regularizacioni parametar

% Dele se podaci.
X = data(:, 1:end-1);
y = data(:, end);
X = map_feature(X(:,1), X(:,2));

% Treniramo model.
[w, loss_history] = train(X, y, mu, iterations, reg, lambda);

fprintf(1, 'Training completed. w values:\n');
disp(w);

% Prikazujemo dobijeni model.
plot_decision_boundary(w, X, y);

% Prikazujemo kako je tekao proces minimizacije funkcije gubitka.
figure;
plot(1:length(loss_history), loss_history);
xlabel('iteration');
ylabel('loss(w)');
legend('Changes of loss(w) during minimization.');
