% Ucitavanje podataka.
data = load('dataset.txt');
fprintf(1, 'Loaded dataset of size:\n');
disp(size(data));

% Postavljaju se parametri.
mu = 0.0005;                % korak ucenja
iterations = 1000000;       % broj iteracija za gradijentni spust
reg = 'l1';                 % tip regularizacije, l1 ili l2
lambda = 0.1;               % regularizacioni parametar

% Vrsi se podela podataka.
X = data(:, 1:end-1);
y = data(:, end);
m = length(y);
rng(42)
X = [ones(m, 1) X normrnd(0,1,m,1)];

% Vrsi se trening koristeci algoritam gradijentnog spusta.
[w, loss_history] = train(X, y, mu, iterations, reg, lambda);

disp('Training completed. Model coeficients:')
disp(w);

% Ilustracija dobijenog modela.
plot_decision_boundary(w, X, y);

% Grafikon minimizacije funkcije gubitka.
figure;
plot(1:length(loss_history), loss_history);
xlabel('iteration');
ylabel('loss(w)');
legend('Changes of loss(w) during minimization.');
