% Ucitavamo podatke.
data = load('dataset.txt');
disp('Loaded dataset of size:');
disp(size(data));

% Postavljamo parametre ucenja.
mu = 0.005;                     % stepen ucenja
iterations = 10000;             % broj iteracija koliko se izvrsava gradijentni spust
reg = 'l2';                     % regularizacija moze biti 'l1' ili 'l2'
lambda = 1;                     % postavljamo regularizacioni parametar

% Pozivamo trening modela.
[w, loss_history] = train(data, mu, iterations, reg, lambda);

disp('Training completed. w coeficients:');
disp(w);

X = data(:, 1:end-1);
y = data(:, end);
N = length(y);
X = [ones(N, 1) X];

% Prikazujemo podatke i model koji smo dobili.
figure;
plot(X(:, 2:end), y, 'rx', 'MarkerSize', 5);
xlabel('Population of city in 10,000s');
ylabel('Profit in 10,000$');
hold on;
disp(size(X*w));
plot(X(:, 2), X*w, '-');
legend('Training data', 'Linear regression');
hold off;

% Prikazujemo kako je tekao proces minimizacije funkcije gubitka.
figure;
plot(1:iterations, loss_history);
xlabel('iteration');
ylabel('loss');
legend('Changes of loss function during minimization.');
