% Ucitavanje podataka
data = load('data.txt');
X = data(:, 1);
y = data(:, 2);
N = length(y);
lambda = 0;

% Pravljanje polinomijalnog modela
n = 10;
initial_X = X;
for i = 2:n
    X = [X, initial_X.^i];
end
X = [ones(N, 1) X];

% Racunanje i ispis koeficijenata modela
W = inv(X' * X+lambda*eye(size(X,2))) * X' * y;
disp('Model');
disp(W);

% Prikaz podataka i modela
figure;
plot(X(:, 2), y, 'rx', 'MarkerSize', 5);
hold on;
x = linspace(min(initial_X), max(initial_X));
plot(X(:, 2), X*W, '-');
legend('Training data', 'Linear regression');
xlabel('x');
ylabel('y');
