function class = knn(data, K, input)
% Algoritam klasifikacije - K najblizih suseda

    % Delimo trening skup na vektor atributa i vektor labela
    X = data(:, 1:end-1);
    y = data(:, end);
    n = length(y);
        
    % Pripremamo udaljenost
    d = @(u, v) sqrt(sum((u-v).^2)); % euklidsko rastojanje
    dists = zeros(n, 1);
    
    % Racunamo udaljenost do svih tacaka
    for i = 1:n
        dists(i) = d(X(i, :), input);
    end
    
    % Uzimamo indekse od K najblizih
    [dummy, indices] = sort(dists);
    nearest = indices(1:K);
    
    % Biramo tih K najblizih pomocu gore izabranih indeksa
    nearest_neighbours = X(nearest, :);
    nearest_labels = y(nearest);
    
    % Crtamo linije ka najblizim susedima
    for i = 1:K
        draw_line([nearest_neighbours(i, 1), nearest_neighbours(i, 2)], [input(1), input(2)]);
        pause(1);
    end
  
    % Najcescu klasu prijavljujemo kao rezultat
    class = mode(nearest_labels);

end

