#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <libgen.h>
#include <iostream>
#include <unistd.h>
#include <fstream>
#include <assert.h>
#include <fpu_control.h>

#include "SATinstance.h"
#include "global.h"
#include "featurevalues.h"
#include "bestsolvers.h"
#include "solvertimes.h"

using namespace std;

Stopwatch gSW;
double preTime;

int  OrigNumVars, OrigNumClauses;

int gTimeOut;
// int numFeats=64;
int getTimeOut(void)
{
	char * value = getenv("SATTIMEOUT");

	if (value == NULL)
		return(2419200); // -- 4 weeks

	return atoi(value);
}

double d3(double *vec1, double *vec2, int n)
{
  int i;
  double dist=0;
  for(i=0; i<n; i++)
    dist+=fabs(vec1[i]-vec2[i])/(sqrt(vec1[i]*vec2[i])+1);
  return dist;
}

struct distInfo
{
  double distance;
  int index;
};

int cmpdist(const void *di1, const void *di2)
{
  double d=(*(const distInfo **)di1)->distance-(*(const distInfo **)di2)->distance;
  if(d<0)
    return -1;
  else if(d>0)
    return 1;
  else
    return 0;
}

int nearestNeighbor(double rawFeat[], double features[][FEAT_NUMBER], int numInstances)
{
  int minind=0;
  double mindist=0;
  for(int i=0; i<numInstances; i++) {
    double dist=d3(rawFeat,features[i],FEAT_NUMBER);
    if(i==0 || dist<mindist) {
      minind=i;
      mindist=dist;
    }
  }
  return minind;
}
                                

int main(int argc, char** argv)
{

  char *filename;
  double thisAlgScore;
  int featureOK = 1;
  ifstream fin;
  string linefoo;
  int featNumber;
  double *rawFeat;
  char** featnames;
  int takeflag;
  long seed;
  char* strseed;
  int nn=1;


  fpu_control_t oldcw, newcw;
  _FPU_GETCW(oldcw); newcw = (oldcw & ~_FPU_EXTENDED) | _FPU_DOUBLE; _FPU_SETCW(newcw);
    
  
  int returnVal=0;
  SATinstance* prob=NULL;
  
  // get current path from argv[0]
  string fullPath(argv[0]);
  size_t lastSlashPos=fullPath.find_last_of('/');
  string myownpath=fullPath.substr(0,lastSlashPos);
  if (lastSlashPos==-1){
    myownpath=".";
  }
  const char* mypath=myownpath.c_str();
  
  
  //   char *dir = dirname(argv[0]);
  
  if (argc < 2) {
    printf ("usage: ArgoSmartkNN <instance filename> [number of neighbors]\n");
    exit(1);
  }
  else if(argc == 3)
    nn = atol(argv[2]);
  
  seed=0; //(long)time(NULL);
  strseed = new char[64];
  sprintf(strseed, "%ld", seed);

  filename = argv[1];
  
  // -- start bookkeeping
  gTimeOut = getTimeOut();
  gSW.Start();
  BuildSolvers(strseed);
  
  
  prob = new SATinstance(filename, seed);  
  prob->computeFeatures();
  if (prob->getNumVals()==0 ||prob->getNumClaus()==0)
    featureOK=0;
  
  int solver=0;
  
  if (featureOK){
    featNumber = prob->getNumFeatures();
    assert(featNumber==FEAT_NUMBER);
    rawFeat = prob->getFeatureVals();
    featnames= prob->getFeatureNames();
    if(nn==1)
    {
      int minind=nearestNeighbor(rawFeat,features,numInstances);
      solver=bestsolvers[minind];
    }
    else
    {  
      distInfo *distances[numInstances];
      double scores[13];
      for(int i=0; i<numInstances; i++) {
        distances[i]=(distInfo *)malloc(sizeof(distInfo));
        distances[i]->distance=d3(rawFeat,features[i],featNumber);
        distances[i]->index=i;
      }
  
      qsort(distances,numInstances,sizeof(distInfo *),cmpdist);

      int bestind=0;
      double bestscore=0;
      for(int i=0; i<13; i++)
      {
        scores[i]=0;
        for(int j=0; j<nn; j++)
        {
          double solvtime=solvertimes[distances[j]->index][i];
          if(solvtime<1500)
            scores[i]+=solvtime;
          else
            scores[i]+=15000;                
        }
        if(i==0 || scores[i]<bestscore || (scores[i]==bestscore && solverscores[i]<solverscores[bestind]))
        {
          bestind=i;
          bestscore=scores[i];
        }
      } 
      solver=bestind;

      for(int i=0; i<numInstances; i++)
        free(distances[i]);
    }
  }
  else
    solver=8;

  cout << "c Solver: " << binSolvers[solver]->name << endl;
  returnVal = binSolvers[solver] -> execute(filename, -1,mypath);
  fin.open(binSolvers[solver]->outFileName);
  if (fin.is_open()){
    while (fin){
      getline(fin, linefoo);
      if(linefoo.find("s SATISFIABLE")==0){
	cout << linefoo << endl;
	returnVal = 10;
      }
      if(linefoo.find("s UNSATISFIABLE")==0){
	cout << linefoo << endl;
	returnVal = 20;
      }
      if(linefoo.find("v")==0){
	cout << linefoo << endl;
      }
    }
    fin.close();
    remove(binSolvers[solver]->outFileName);
    binSolvers[solver]->cleanup();

    if (returnVal == 10 | returnVal == 20){
      printf("c ArgoSmart %d-NN time: %lf\n", nn, gSW.TotalLap());
      return returnVal;
    }
  }
  return 0;
}
