#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <libgen.h>
#include <iostream>
#include <unistd.h>
#include <fstream>
#include <assert.h>
#include <fpu_control.h>

#include "SATinstance.h"
#include "global.h"
#include "featurevalues.h"
#include "bestsolvers.h"
#include "solvertimes.h"

using namespace std;

Stopwatch gSW;
double preTime;

int  OrigNumVars, OrigNumClauses;

int gTimeOut;
// int numFeats=64;
int getTimeOut(void)
{
	char * value = getenv("SATTIMEOUT");

	if (value == NULL)
		return(2419200); // -- 4 weeks

	return atoi(value);
}

int main(int argc, char** argv)
{

  char *filename;
  char outfile[512];
  double thisAlgScore;
  int featureOK = 1;
  ifstream fin;
  string linefoo;
  int featNumber;
  double *rawFeat;
  char** featnames;
  int takeflag;
  long seed;
  char* strseed;
  int nn=1;


  fpu_control_t oldcw, newcw;
  _FPU_GETCW(oldcw); newcw = (oldcw & ~_FPU_EXTENDED) | _FPU_DOUBLE; _FPU_SETCW(newcw);
    
  
  int returnVal=0;
  SATinstance* prob=NULL;
  
  // get current path from argv[0]
  string fullPath(argv[0]);
  size_t lastSlashPos=fullPath.find_last_of('/');
  string myownpath=fullPath.substr(0,lastSlashPos);
  if (lastSlashPos==-1){
    myownpath=".";
  }
  const char* mypath=myownpath.c_str();
  
  
  //   char *dir = dirname(argv[0]);
  
  if (argc < 2) {
    printf ("usage: ArgoSmart <instance filename> [number of neighbors]\n");
    exit(1);
  }
  else if(argc == 3)
    nn = atol(argv[2]);
  
  seed=(long)time(NULL);
  strseed = new char[64];
  sprintf(strseed, "%ld", seed);

  filename = argv[1];
  
  // -- start bookkeeping
  gTimeOut = getTimeOut();
  gSW.Start();
  BuildSolvers(strseed, outfile);
  
  
  prob = new SATinstance(filename, seed);  
  prob->computeFeatures();
  if (prob->getNumVals()==0 ||prob->getNumClaus()==0) {
    cout <<"c Instance can be solved by unit propodation alone!!!\n";
    featureOK=0;
  }
  
  
  if (featureOK){
    featNumber = prob->getNumFeatures();
    assert(featNumber==FEAT_NUMBER);
    rawFeat = prob->getFeatureVals();
    featnames= prob->getFeatureNames();
    remove(outfile);
  }

  ofstream of((string(argv[1])+".ft").c_str());
  for(int i=0; i<FEAT_NUMBER; i++)
    of << rawFeat[i] << " ";
  of.close();

  return 0;
}
