.text
.align 2


.global sum

@ Funkcija:
@ 
@ int sum(int a[], int n);
@
@ izracunava sumu elemenata niza celih brojeva. Argumenti funkcije su:
@
@   -- r0 -- int * a  -- adresa pocetka niza
@   -- r1 -- int n -- duzina niza
@
sum:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Postavljamo na stek vrednost registra r4 koji cemo koristiti
	@ u funkciji (registri r4-r10 moraju da se sacuvaju ako se 
	@ koriste, po konvencijama).
	str r4, [sp, #-4]!


	@ Komentari u nastavku instrukcija priblizno opisuju njihove 
	@ C-ovske ekvivalente.

	mov r2, #0                       @  i = 0;
	mov r3, #0                       @  S = 0;
loop:
	cmp r2, r1                       @  while(i < n) {
	bge end_loop             
	ldr r4, [r0, r2, asl #2]         @  S = S + a[i];
	add r3, r3, r4
	add r2, r2, #1                   @  i = i + 1;
	b loop                           @  }


end_loop:
	mov r0, r3                       @  return S;

done:

	@ Vracamo vrednost registra r4 sa steka.
	ldr r4, [sp], #4

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
