.text
.align 2


.global arm_strlen

@ Funkcija:
@
@ int arm_strlen(char * s);
@
@ izracunava duzinu stringa s. Argument funkcije je:
@
@ r0 -- char * s -- adresa pocetka stringa
@
arm_strlen:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Registar r1 ce nam biti pokazivac na tekuci karakter u 
	@ stringu. Registar r0 ce biti brojac karaktera u stringu.
	mov r1, r0
	mov r0, #0

next_char:
	@ Ucitavamo neoznaceni bajt sa adrese r1 i pomeramo pokazivac u 
	@ desno.
	ldrb r2, [r1], #1

	@ Ako je dati karakter jednak nuli, izlazimo iz petlje, a u 
	@ suprotnom uvecavamo brojac.
	cmp r2, #0
	beq done
	add r0, r0, #1
	b next_char

	@ Na kraju je u registru r0 duzina stringa, sto je upravo 
	@ povratna vrednost funkcije.

done:
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
