.text
.align 2


.global minimax

@ Funkcija:
@
@ void minimax(int a[], int n, int * min, int * max);
@
@ odredjuje najveci i najmanji element niza celih brojeva. Argumenti 
@ funkcije su:
@
@ -- r0 -- int * a -- adresa pocetka niza
@ -- r1 -- int n -- duzina niza
@ -- r2 -- int * min -- adresa na koju se smesta minimum
@ -- r3 -- int * max -- adresa na koju se smesta maksimum.
@
minimax:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Smestamo na stek registre koje cemo koristiti.
	stmfd sp!, {r4-r6}

	@ Registar r5 ce cuvati maksimum, a r4 minimum. Inicijalno su 
	@ oba jednaka prvom elementu niza.
	ldr r5, [r0], #4  
	mov r4, r5              
	sub r1, r1, #1                  

 
loop:
	@ Dokle god je n > 0
	cmp r1, #0                   
	beq end_loop
 
        @ Ucitavamo u r6 tekuci element niza, i pomeramo pokazivac a u 
	@ desno.    
	ldr r6, [r0], #4               

	@ Uporedjujemo ucitani element sa maksimumom.
	cmp r6, r5

	@ Ako je vece, onda je to novi maksimum.
	movgt r5, r6

	@ Uporedjujemo ucitani element sa minimumom. 
	cmp r6, r4
	
	@ Ako je manje, onda je to novi minimum.
	movlt r4, r6                 
	
	@ Umanjujemo n i prelazimo na sledecu iteraciju. 
	sub r1, r1, #1                  
	b loop                          

end_loop:

	@ Cuvamo podatke na za to predvidjene lokacije.
	str r4, [r2]                     
	str r5, [r3]

	@ Vracamo vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r6}

done:
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
