.text
.align 2


.global max_element

@ Funkcija:
@ 
@ int max_element(int a[], int n);
@
@ odredjuje najveci element u nizu. Argumenti funkcije su:
@
@ -- r0 -- int * a -- adresa pocetka niza
@ -- r1 -- int n -- duzina niza
@
max_element:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Registar r3 ce sadrzati maksimum (inicijalno a[0]).
	ldr r3, [r0], #4                
	sub r1, r1, #1                  
 
loop:
	@ Dok je n > 0
	cmp r1, #0                   
	beq end_loop  

	@ Ucitavamo *a u r2, i pomeramo a u desno (a++).           
	ldr r2, [r0], #4               

	@ Uporedjujemo tekuci element sa maksimumom.
	cmp r2, r3

	@ Ako je veci, onda je to novi maksimum.
	movgt r3, r2                   

	@ Smanjujemo n i prelazimo na sledecu iteraciju.
	sub r1, r1, #1                  
	b loop                          

end_loop:
	@ Smestamo maksimum u r0.
	mov r0, r3                       

done:
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
