.text
.align 2


.global euler

@ Funkcija:
@
@ int euler(int n);
@
@ odredjuje broj celih brojeva m, 1 <= m < n takvih da su uzajamno prosti
@ sa n. Argument funkcije je:
@
@ int n -- r0 --  dati broj n.
@
euler:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku registre koje cemo da koristimo.
	stmfd sp!, {r4-r6} 

	@ Registar r6 ce sadrzati brojac uzajamno prostih brojeva sa n.
	@ Registar r5 ce sadrzati broj n, a registar r4 ce nam sadzati
	@ tekuci broj m za koji ispitujemo da li je uzajamno prost sa n. 
	mov r6, #0 
	mov r5, r0 
	mov r4, #1 

	@ U petlji se prolazi po m od 1 do < n. 
next_number:
	@ Ispitujemo da li je m == n i u tom slucaju izlazimo iz petlje.
	cmp r4, r5
	beq last_number

	@ Poziva se funkcija nzd(n,m)
	mov r0, r4
	mov r1, r5
	bl nzd

	@ Ako je nzd(n,m) == 1, uvecavamo brojac r6.
	cmp r0, #1
	addeq r6, r6, #1

	@ Prelazimo na sledece m.
	add r4, r4, #1
	b next_number

last_number:
	@ Upisujemo rezultat u r0.
	mov r0, r6

	@ Skidamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r6}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}

@ Funkcija:
@
@ int nzd(int n,int m);
@
@ izracunava najveci zajednicki delilac pozitivnih celih brojeva n i m.
@ Argumenti funkcije su:
@ 
@ -- int n  -- r0
@ -- int m  -- r1
@ 
nzd:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Smestamo na stek registre koje cemo koristiti.
	stmfd sp!, {r4, r5}
		
	@ Registar r4 ce sadrzati n, a registar r5 ce sadrzati m.
	mov r4, r0
	mov r5, r1

	@ U petlji implementiramo Euklidov algoritam.
next_iteration:
	@ Ispitujemo da li je m == 0. Ako jeste, onda je n upravo nzd.
	cmp r5, #0	
	beq last_iteration

	@ Pozivamo funkciju biblioteke __modsi3(n,m) koja odredjuje n % m.
	mov r0, r4
	mov r1, r5
	bl __modsi3
	
	@ n dobija vrednost m, dok m dobija vrednost n % m.
	mov r4, r5
	mov r5, r0

	@ Prelazimo na sledecu iteraciju.
	b next_iteration

last_iteration:
	@ Vrednost n upisujemo u r0.
	mov r0, r4

	@ Skidamo sa steka vrednosti registara koje smo koristili.
	ldmfd sp!, {r4, r5}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
	
