`define FPU_ADD 3'b000
`define FPU_SUB 3'b001
`define FPU_MUL 3'b010
`define FPU_DIV 3'b011
`define FPU_CMP 3'b100
`define FPU_RND 3'b101

module fpu(e_in, op_sel, x, y, r, ri, s, z);
   input e_in;
   input [2:0] op_sel;
   input [63:0] x, y;
   output [63:0] r;
   output reg	 s, z;
   output reg [31:0] ri;
   
   real 	 R = 0;
   real 	 rx, ry;

   initial
     begin
	s = 0;
	z = 0;
	ri = 0;
     end
   
   always @(x)
     rx = $bitstoreal(x);
   always @(y)
     ry = $bitstoreal(y);
   
   
   assign r = $realtobits(R);


   
   always @(e_in or rx or ry or op_sel)
     begin
	case(op_sel)
	  `FPU_ADD:
	    begin
	       R = rx + ry;
	       s = 0;
	       z = 0;
	       ri = 0;	       
	    end
	  `FPU_SUB:
	    begin
	       R = rx - ry;
	       s = 0;
	       z = 0;
	       ri = 0;
	    end
	  `FPU_MUL:
	    begin
	       R = rx * ry;
	       s = 0;
	       z = 0;
	       ri = 0;
	    end
	  `FPU_DIV:
	    begin
	       R = rx / ry;
	       s = 0;
	       z = 0;
	       ri = 0;
	    end
	  `FPU_CMP:
	    begin
	       R = 0;
	       ri = 0;	       
	       s = (x < y);
	       z = (x == y);
	    end
	  `FPU_RND:
	    begin
	       R = 0;
	       s = 0;
	       z = 0;	    
	       ri = $rtoi(rx);	       
	    end
	endcase
     end

endmodule
