#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX 100

/* sortiranje ucesljavanjem */
void
merge_sort (int a[], int l, int d)
{
  int s;
  int b[MAX];	/* pomocni niz */
  int i, j, k;

  /* Izlaz iz rekurzije */
  if (l >= d)
    return;

  /* Odredjujemo sredisnji indeks */
  s = (l + d) / 2;

  /* rekurzivni pozivi */
  merge_sort (a, l, s);
  merge_sort (a, s + 1, d);

  /* Inicijalizacija indeksa. Indeks i prolazi
     krozi levu polovinu niza, dok indeks j
     prolazi kroz desnu polovinu niza. Indeks
     k prolazi kroz pomocni niz b[] */
  i = l;
  j = s + 1;
  k = 0;

  /* "ucesljavanje" koriscenjem pomocnog niza b[] */
  while(i <= s && j <= d)
  {
    if(a[i] < a[j])
     b[k++] = a[i++];
    else
     b[k++] = a[j++];
  }

  while(i <= s)
   b[k++] = a[i++];

  while(j <= d)
   b[k++] = a[j++];

  /* prepisujemo "ucesljani" niz u originalni niz */
  for (k = 0, i = l; i <= d;  i++, k++)
    a[i] = b[k];

}


/* Test program */
int main(int argc, char ** argv)
{
  int a[MAX];
  int n, i;
  int x;


  /* Niz brojeva se zadaje na komandnoj liniji */
  for(n = 0; n + 1 < argc && n < MAX; n++)
    a[n] = atoi(argv[n + 1]);
  
  /* Poziv funkcije */
  merge_sort(a, 0, n - 1);

  /* Prikaz niza */
  for(i = 0; i < n; i++)
   printf("%d ", a[i]);
  putchar('\n');
  
  return 0;
}
