; Za promenljive cije se vrednosti menjaju definisemo
; konstante koje predstavljaju stanja te promenljive
; u toku rada programa (max0, max1, ..., i0, i1, ...)
; Za svaku naredbu pisemo odgovarajuci izraz koji povezuje
; vrednosti promenljivih u odgovarajucim stanjima
; Na ovaj nacin dobijamo formulu P koja predstavlja rad
; naseg programa. Sada mora da vazi P => Q, gde je Q
; definisani postuslov. Otuda formula P /\ ~Q mora biti
; nezadovoljiva.
;
; Niz se modeluje Array sortom. Zato koristimo QF_AUFLIA
; logiku koja dozvoljava istovremeno koriscenje nizova,
; celobrojne aritmetike i neinterpretiranih funkcijskih
; simbola. 
;

(set-logic QF_AUFLIA)
(declare-fun a () (Array Int Int))
(declare-fun max0 () Int)
(declare-fun max1 () Int)
(declare-fun max2 () Int)
(declare-fun max3 () Int)
(declare-fun max4 () Int)
(declare-fun i0 () Int)
(declare-fun i1 () Int)
(declare-fun i2 () Int)
(declare-fun i3 () Int)
(declare-fun i4 () Int)

(assert
  (and

    ; Pocetne vrednosti za max i i
    (= max0 (select a 0))
    (= i0 1)

    ; Razmotavanje petlje (4 iteracije)
    (ite (> (select a i0) max0) (= max1 (select a i0)) (= max1 max0))
    (= i1 (+ i0 1))
    (ite (> (select a i1) max1) (= max2 (select a i1)) (= max2 max1))
    (= i2 (+ i1 1))
    (ite (> (select a i2) max2) (= max3 (select a i2)) (= max3 max2))
    (= i3 (+ i2 1))
    (ite (> (select a i3) max3) (= max4 (select a i3)) (= max4 max3))
    (= i4 (+ i3 1))

     ; Postuslov Q glasi: max na kraju mora biti jednak nekom od elemenata
     ; niza, a istovremeno mora biti veci ili jednak od svih. Negacija tog
     ; uslova sledi u nastavku formule.
     (or (and (distinct max4 (select a 0))
              (distinct max4 (select a 1))
              (distinct max4 (select a 2))
	      (distinct max4 (select a 3))
              (distinct max4 (select a 4)))
      (< max4 (select a 0)) 
      (< max4 (select a 1)) 
      (< max4 (select a 2)) 
      (< max4 (select a 3))
      (< max4 (select a 4)))	
  )
)
(check-sat)
(exit)