; Primer 11 (verifikacija)
;
; Neka je P formula koja opisuje logiku fragmenta
; koda koji se verifikuje. Neka ja Q postuslov koji
; treba dokazati da vazi. SMT resavac dokazuje da je
; formula P /\ ~Q nezadovoljiva.
;
(set-logic QF_LIA)
(declare-fun max () Int)
(declare-fun x () Int)
(declare-fun y () Int)
(assert
 (and 
   ; Uslov koji kodira if-then-else
   (or
     (and (> x y) (= max x)) 
     (and (>= y x) (= max y)) 
   )

   ; Moze i ovako:
   ; (ite (> x y) (= max x) (= max y))


   ; Negacija postuslova Q koji kaze da je max = max{x,y}, odnosno
   ; da je (max = x \/ max = y) /\ (max >= x) /\ (max >= y)
   (or (and (distinct max x) (distinct max y)) (< max x) (< max y))
 )
)
(check-sat)
(exit)
